#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




# for autoloading...
proc editor {} {}

composite_define Editor {
        {-onfileselectcommand onFileSelectCommand Command nop composite_configPrivateNop}
        {-onsavecommand onSaveCommand Command nop composite_configPrivateNop}
} Editor::initProc

proc Editor::initProc { w args } {
        upvar #0 config$w config
        upvar #0 $w data
        global gui_flags
        global Editor_flags
        global Editor_library
        
        pack [buttonbar $w.bbar] -fill x
        pack [scrollable text $w.text \
                -font $gui_flags(font,codeentry) \
                -relief sunken \
                -borderwidth 2] -expand yes -fill both -side right
        $w.bbar addbutton button \
                -text "Open..." \
                -command "$w openquery"
        $w.bbar addbutton button \
                -text "Save" \
                -command "$w save"

        if $gui_flags(debug) { puts "Leaving Editor"}
        return $w
}

#----------------------------------------------------------------------------
# Menu entries suitable for MakeMenus
#
#----------------------------------------------------------------------------

proc Editor::menu_entries { w } {
    list                                \
        [list command "New" "$w newfile" 0] \
        [list command "Open..." "$w selectfile" 0] \
        [list command "Save" "$w save" 0] \
        [list command "Save As..." "$w saveas" 5]
}


#----------------------------------------------------------------------------
# Widget commands
#
#----------------------------------------------------------------------------

#composite_configFlag Editor fileSelectCommand { w option value } {
#       if ![info exists selection] { set selection [$w selection] }
#       return private
#}


composite_subcommand Editor text { w args } {
        if {[llength $args] > 0} {
            eval $w.text.b $args
        } else {
            return [$w.text.b]
        }
}

composite_subcommand Editor loadfile { w file } {
        upvar #0 $w data
        set data(file) $file
        if [catch {set f [open $data(file)]} err] {
            errormessage $w.error $err
            return
        }
        set text [read $f]
        $w.text.b delete 1.0 end
        $w.text.b insert insert $text
        close $f
        $w.text.b yview 1.0
}

composite_subcommand Editor newfile { w } {
        upvar #0 $w data
        upvar #0 config$w config
        $w savequery
        unset data(file)
        $w.text.b delete 1.0 end
        regsub %f $config(onFileSelectCommand) {{}} command
        eval $command
}

composite_subcommand Editor savequery { w } {
        upvar #0 $w data
        upvar #0 config$w config
        set text [$w.text.b get 1.0 end] 
        if {![info exists data(file)]} {
           set diff [expr {$text != ""}]
        }
        if ![info exists diff] {
            set f [open $data(file)]
            set old [read $f]
            close $f
            set diff [expr {$old != $text}]
        }
        if $diff {
            if ![info exists data(file)] { 
                set name "<unknown>" 
            } else { set name $data(file) }
            switch -- [choice $w.verify \
                -text "Save changes to $name?" \
                -buttons [list Yes No Cancel]] {
               Yes { $w save  }
               No { }
               Cancel { return }
            }
        }
}

composite_subcommand Editor openquery { w } {
        upvar #0 $w data
        upvar #0 config$w config
        $w savequery
        set file [selectfile -dirvariable pwd -message "Select a file to edit:"]
        if {$file != ""} {
            $w loadfile $file
        }
        regsub %f $config(onFileSelectCommand) $data(file) command
        eval $command
}

composite_subcommand Editor save { w } {
        upvar #0 $w data
        upvar #0 config$w config
        if ![info exists data(file)] { $w saveasquery }
        catch {exec cp $data(file) $data(file).bak}
        set f [open $data(file) w]
        puts $f [$w.text.b get 1.0 end]
        close $f
        regsub %f $config(onSaveCommand) $data(file) command
        eval $command
}

composite_subcommand Editor saveasquery { w } {
        upvar #0 $w data
        set file [selectfile -new 1 -dirvariable pwd -message "Save as:"]
        if {$file!=""} {
            set data(file) $file
            $w save
        }
}

