#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




proc Help::www_invoke { url } {
        global Help_flags
        global feedback
        global busy
        incr busy

        # Invoke netscape by remote control if it exists

        if {[string match *etscape* $Help_flags(wwwBrowser)]} {
            if [catch {eval exec $Help_flags(wwwBrowser) [list -raise -remote openURL($url)] >& /dev/null} err] {
                # remote netscape invocation failed - drop through to spawn new browser.
            } else {
                # remote netscape invocation happened OK
                exec /bin/sleep 2
                incr busy -1; return
            }
            
        }

        # Invoke mosaic by remote control if it exists
        if {![info exists Help_flags(www_pid)] && $Help_flags(cooptMosaic) && [string match *osaic* $Help_flags(wwwBrowser)]} {
            if [catch {set processes [split [eval exec $Help_flags(psCommand)] \n]} err] {
                errormessage .error $err; incr busy -1; return
            }
            set psindex [lsearch -glob $processes *osaic*]
            if {$psindex!=-1} {
                set Help_flags(www_pid) [lindex [lindex $processes $psindex] 0]
            }
        }
        if {[info exists Help_flags(www_pid)] && [string match *osaic* $Help_flags(wwwBrowser)]} {
            if [catch {
                    set f [open /tmp/Mosaic.$Help_flags(www_pid) w]
                    puts $f "goto"
                    puts $f $url
                    close $f
                    eval exec $Help_flags(killCommand) [list -USR1 $Help_flags(www_pid)]
            }] {
                unset Help_flags(www_pid)
            }
        }
        if ![info exists Help_flags(www_pid)] {
            set feedback [list {} "Executing $Help_flags(wwwBrowser)"]
            if [catch {set Help_flags(www_pid) [eval exec $Help_flags(wwwBrowser) [list $url] &]} err] {
                errormessage .error $err; incr busy -1; return
            }
            exec /bin/sleep 5
        }
        incr busy -1
}

proc Help::latex2html_invoke { url_dir labels_file ref } {
        global HolHelp_library
        global gui_flags
        global busy
        incr busy
        if [catch {exec $gui_flags(perl) \
                        $HolHelp_library/src/latex2html_ref.pl \
                        $url_dir \
                        $labels_file \
                        $ref} url] {
            errormessage .error $url
            incr busy -1; return
        }
        Help::www_invoke $url
        incr busy -1; return

}

proc Help::tutorial { ref } {
        global install_dir_tkhol
        Help::latex2html_invoke \
                file:$install_dir_tkhol/doc/Tutorial/tutorial \
                $install_dir_tkhol/doc/Tutorial/tutorial/labels.pl \
                TkHolTut$ref
}

proc Help::manual { ref } {
        global install_dir_tkhol
        Help::latex2html_invoke \
                file:$install_dir_tkhol/doc/Manual/manual \
                $install_dir_tkhol/doc/Manual/manual/labels.pl \
                TkHolMan$ref
}

proc Help::implementation { ref } {
        global install_dir_tkhol
        Help::latex2html_invoke \
                http://www.cl.cam.ac.uk/users/drs1004/TkHolWorkbench/doc/Implementation/implementation/ \
                $install_dir_tkhol/doc/Implementation/implementation/labels.pl \
                TkHolImp$ref
}




proc Help::hol90_help { url_ext } {
        global Help_flags
        Help::www_invoke $Help_flags(hol90_URL)/$url_ext
}


proc Help::menu_entries { class } {

        global Help_flags
        global gui_flags
        global version

#           [list command "The Manual Entry for $class..." "Help::manual $class" 0]

        list \
            [list command "The Tutorial Entry for $class..." "Help::tutorial $class" 0] \
            [list sep]                                          \
            [list command "The Complete TkHol Tutorial..." "Help::tutorial {}" 0] \
            [list command "The Complete TkHol User's Manual..." "Help::manual {}" 0] \
            [list command "HOL88 Manual/HOL WWW Search..." "Help::www_invoke \$Help_flags(lal_URL)" 0] \
            [list command "HOL90 Notes..." "Help::www_invoke \$Help_flags(hol90_URL)" 0] \
            [list sep]                                          \
            [list command "Send Some Feedback..." "error {(user feedback)}" 10] \
            [list sep]                                          \
            [list command "About $gui_flags(title)..." "Help::www_invoke http://www.cl.cam.ac.uk/users/drs1004/TkHolWorkbench.html" 0]

}


