(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)




functor PPToStrings (structure PP: PP_sig) : PPToStrings_sig =
struct
   structure PP = PP;
   open PP.PP.LabelPPBoxes.Scale;
   open PP.PP.LabelPPBoxes;
   open PP.PP;
   open PP.Labels;
(*   open Portable; *)
   type ('val,'branch) ppfun = 
        {depth:int, outer_prec:PrettySupport.precedence} -> PP.parameters -> ('val * 'branch label) -> 'branch label ppbox
   val mk_ppfun = I
   val dest_ppfun = I
   type linechar = int * int
   type 'branch linechar_textitem = {From: linechar,To: linechar,Label: 'branch label,Text: string Portable.option}
   datatype 'branch texttree = NODE of ('branch linechar_textitem *  'branch texttree list)

   type look = string      
local
   fun linechar_geq (pos1_l,pos1_c) (pos2_l:int,pos2_c:int) =
       (pos1_l > pos2_l) orelse ((pos1_l = pos2_l) andalso (pos1_c >= pos2_c))
   fun linechar_leq (pos1_l,pos1_c) (pos2_l:int,pos2_c:int) =
       (pos1_l < pos2_l) orelse ((pos1_l = pos2_l) andalso (pos1_c <= pos2_c))
   fun inc_linechar (l,c) = (l,c+1)
   fun dec_linechar (l,c) = (l,c-1)
   fun textitem_not_nil (textitem': 'a linechar_textitem) = 
        let val textitem = textitem' 
        in
          linechar_geq (#To textitem) (#From textitem)
        end
   fun reduct_textitem this (other': 'a linechar_textitem) =
         let val {From=from,To=to,Label=label,Text=text} = this
             val other = other' 
             val l1 = {From=from,To=dec_linechar (#From other),Label=label,Text=text}
             val l1ok = textitem_not_nil l1
             val l2 = {From=inc_linechar (#To other),To=to,Label=label,Text=text}
             val l2ok = textitem_not_nil l2
         in (if (l1ok) then SOME l1 else NONE,
             if (l2ok) then SOME l2 else NONE)
         end
   
   fun ltree_textitem (NODE (textitem,_)) = textitem
   fun reduce_textitem_against_ltree_list (h::t) textitem =
       let 
          val (front,back) = reduct_textitem textitem (ltree_textitem h)
          val reduced_back = case back of
             NONE => []
           | SOME back' => reduce_textitem_against_ltree_list t back'
       in
          case front of
             NONE => (reduce_texttree_ltree h)@reduced_back
           | SOME front' => front'::(reduce_texttree_ltree h)@reduced_back
       end
     | reduce_textitem_against_ltree_list [] textitem = [textitem]
   and reduce_texttree_ltree (NODE (textitem,subtrees)) =
        reduce_textitem_against_ltree_list subtrees textitem 
in
   val reduce_texttree =  reduce_texttree_ltree
end;

val look_of_string = I
val string_of_look = I
val whitespace_look_ref = ref (look_of_string "Teletype-Medium-R-Normal-Normal|*-*-*-*-Black-*-0-0-0");
fun set_whitespace_look s = (whitespace_look_ref := s);
fun whitespace_look () = (!whitespace_look_ref);

val default_look_ref = ref (look_of_string "Teletype-Medium-R-Normal-Normal|*-*-*-*-Black-*-0-0-0");
fun set_default_look s = (default_look_ref := s);
fun default_look () = (!default_look_ref);

fun string_of_linechar (l:int,c:int) =
       makestring l ^ "." ^ makestring c;

(* Nb. zero length text items seem to indicate spaces or
carriage returns.  I try to work out which is which from the
positions. *)

fun whitespace ((fl,fc),(tl,tc)) =
    (itlist concat (for fl (tl-1) (fn _ => "\n")) "") ^ 
    (if (fl = tl) 
     then (itlist concat (for fc tc (fn _ => " ")) "")
     else (itlist concat (for 0 tc (fn _ => " ")) ""));
    
   fun string_of_branchlist string_of_branch bl = 
          if (null bl) then ""
          else end_itlist (fn s1 => fn s2 => (s1 ^ "-" ^ s2)) (map string_of_branch (rev bl));
   
fun strings_of_textitem string_of_branch (textitem: 'a linechar_textitem) = 
    [string_of_linechar (#From textitem),
     string_of_linechar (#To textitem),
     string_of_branchlist string_of_branch (#Branches (PP.Labels.dest_label (#Label textitem)))]@
     (case (#Text textitem) of 
         Portable.SOME text => 
          [(case (#Look (PP.Labels.dest_label (#Label textitem))) of
               SOME look => string_of_look look
             | NONE => string_of_look (default_look())),
           text]
       | Portable.NONE => 
          [string_of_look (whitespace_look()),
           whitespace (#From textitem,#To textitem)]);

fun textitems_to_strings string_of_funs richtext =
       map (strings_of_textitem string_of_funs) richtext;

fun xy_textitem_to_linechar textitem = 
        let val {From=from,To=to,Label=label,Text=text} = dest_textitem textitem
            val (from_c,from_l) = dest_pos from
            val (to_c,to_l) = dest_pos to
        in
         {From=(num_of_chars from_l,num_of_chars from_c),
         To=((num_of_chars to_l)-1,(num_of_chars to_c)-1),
         Label=label,Text=text}
        end;
         
fun linechar_to_xy (from_l,from_c) = 
        mk_pos (from_c*char_size,from_l*char_size);
         
fun texttree_map f (LabelPPBoxes.NODE (textitem,subtrees)) = 
   NODE (f textitem, map (texttree_map f) subtrees);

fun text_to_textitems pos text =
    case (text_to_texttree (text,pos)) of 
       Portable.SOME ltree => reduce_texttree (texttree_map xy_textitem_to_linechar ltree)
     | Portable.NONE => ([]:'a linechar_textitem list);

fun val_to_textitems {ppfun,initial_label} depthprec parameters {initial_pos,output_width} v =
     text_to_textitems 
        (linechar_to_xy initial_pos) 
        (commit_ppbox (output_width * char_size) (ppfun depthprec parameters (v,initial_label)))


   type parameters =
          {interface_maps : InterfaceMaps.interface_map list, 
           parameters : PP.parameters }
   val mk_parameters = I
   val dest_parameters = I

   
   fun upto from to =
      if (from > to)
      then []
      else from::(upto (from + 1) to);

   fun add_interface_maps interface_maps =
    let val names = map makestring (upto 1 (length interface_maps)) 
        val _ = map (#add (InterfaceMapsRegistry.main_map())) (combine (names,interface_maps))
    in
        names
   end;

   fun remove_interface_maps names =
    let 
        val _ = map (#remove (InterfaceMapsRegistry.main_map())) names
    in
        names
   end;

   fun val_to_strings
         string_of_branch
         {ppfun: ('a,'b)ppfun,initial_kind}
         {interface_maps,parameters:PP.parameters} 
         ppgeom
         v =
    let val names = add_interface_maps interface_maps
        val res = 
           textitems_to_strings string_of_branch 
              (val_to_textitems 
                  {ppfun=ppfun,initial_label=PP.Labels.mk_label {Branches=[],Kind=SOME initial_kind,Look=NONE}}
                  {outer_prec = PP.initial_precedence,depth = PP.initial_depth} 
                  parameters
                  ppgeom
                  v)
        val _ = remove_interface_maps names
    in
       res
    end

end



