structure holpp_lib  = 
struct

val holpp_lib = 
   Library.new_library
         {name = "holpp",
          doc = "HOL ML-Pretty Pretty Printer for the Base HOL Logic, by Richard Boulton and Donald Syme",
          path = holpp_lib_path,
          parents = [find_library "pp", find_library "termpaths"],
          theories = [],
          code = [
		"termkinds.sig",
		"termkinds.sml",
		"holpp_branches.sig",
		"holpp_branches.sml",
		"../pp/hol.pp.destructors.sig",
		"../pp/hol.pp.destructors.sml",
		"../pp/hol.pp.externals.sig",
		"../pp/hol.pp.externals.sml",
		"../pp/hol.pp.sml"
	  ],
          help = [(holpp_lib_path ^ "help/entries/"), (holpp_lib_path ^ "help/internals/")],
          loaded = "fn () => ()"};
end;


