(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)





signature GoalTrees_sig =
  sig
    structure GTrees : GTrees_sig

    type proofstate
    val modify_proof : (GTrees.pstate -> GTrees.BwdProofs.bwdop) -> proofstate -> proofstate
    val top_modify_proof : (GTrees.pstate -> GTrees.BwdProofs.bwdop) -> proofstate -> proofstate
                                      
    val empty_goal : proofstate
    val set_goals : (goal list * GTrees.BwdProofs.bwdop) -> proofstate

    (* Undo *)
    val backup_and_retain_attempt : proofstate -> (proofstate * GTrees.focus)
    val backup_and_discard_attempt : proofstate -> (proofstate * GTrees.focus)
    val set_backup : int -> proofstate -> proofstate
    
    (* Applying a tactic to a goal *)
    val expand : bool -> (tactic * GTrees.BwdProofs.tac) -> GTrees.focus -> proofstate -> proofstate
    val close : GTrees.focus -> proofstate -> proofstate

    (* Determining where the focus should be *)
    val first_focus : proofstate -> GTrees.focus
    val active_foci : proofstate -> GTrees.focus list
    val next_focus : proofstate -> GTrees.focus -> GTrees.focus
    
    (* Seeing what the state of the proof manager is, at a focus *)
    val THENL_mismatch : proofstate -> bool

    val focus_is_active : proofstate -> GTrees.focus -> bool
    val focus_is_opened : proofstate -> GTrees.focus -> bool
    val current_tac : proofstate -> GTrees.focus -> GTrees.BwdProofs.tac

    val propositions_at_focus : proofstate -> GTrees.focus -> GTrees.proposition list
    val at_THENL_start : proofstate -> GTrees.focus -> bool
    val propositions_at_THENL_start : proofstate -> GTrees.focus -> GTrees.proposition list
    val focused_case_at_THENL_start : proofstate -> GTrees.focus -> int
    val refocus_at_THENL_start : int -> proofstate -> GTrees.focus -> GTrees.focus

    (* Seeing what the state of the proof manager is, at the top *)
    val top_is_proved : proofstate -> bool
    val final_thm : proofstate -> thm
    val initial_goal : proofstate -> goal

    val entire_partial_proof : proofstate -> GTrees.PartialBwdProofs.pbwdop
    val executed_proof : proofstate -> GTrees.BwdProofs.bwdop
    val entire_proof : proofstate -> GTrees.BwdProofs.bwdop

    (* semi-imperative versions *)

    val modify_proofI : (GTrees.pstate -> GTrees.BwdProofs.bwdop) -> proofstate ref -> unit
    val top_modify_proofI : (GTrees.pstate -> GTrees.BwdProofs.bwdop) -> proofstate ref -> unit
    val empty_goalI : unit -> proofstate ref
    val set_goalsI : (goal list * GTrees.BwdProofs.bwdop) -> proofstate ref
    val first_focusI : proofstate ref -> GTrees.focus ref
    val backup_and_retain_attemptI : proofstate ref -> GTrees.focus ref -> unit
    val backup_and_discard_attemptI : proofstate ref -> GTrees.focus ref -> unit
    val set_backupI : int -> proofstate ref -> unit

    val expandI : bool -> (tactic * GTrees.BwdProofs.tac) -> GTrees.focus ref -> proofstate ref -> unit
    val closeI : GTrees.focus ref -> proofstate ref -> unit
    val active_fociI : proofstate ref -> GTrees.focus list
    val next_focusI : proofstate ref -> GTrees.focus ref -> unit
    val focus_is_activeI : proofstate ref -> GTrees.focus ref -> bool
    val focus_is_openedI : proofstate ref -> GTrees.focus ref -> bool
    val THENL_mismatchI : proofstate ref -> bool
    val current_tacI : proofstate ref -> GTrees.focus ref -> BwdProofs.tac

    val propositions_at_focusI : proofstate ref -> GTrees.focus ref -> GTrees.proposition list
    val propositions_at_THENL_startI : proofstate ref -> GTrees.focus ref -> GTrees.proposition list
    val at_THENL_startI : proofstate ref -> GTrees.focus ref -> bool
    val focused_case_at_THENL_startI : proofstate ref -> GTrees.focus ref -> int
    val refocus_at_THENL_startI : int -> proofstate ref -> GTrees.focus ref -> unit

    val top_is_provedI : proofstate ref -> bool
    val final_thmI : proofstate ref -> thm
    val initial_goalI : proofstate ref -> goal
    val entire_partial_proofI : proofstate ref -> GTrees.PartialBwdProofs.pbwdop
    val executed_proofI : proofstate ref -> GTrees.BwdProofs.bwdop
    val entire_proofI : proofstate ref -> GTrees.BwdProofs.bwdop
  end
