%----------------------------------------------------------------------------
  This contains examples for DerLem package, including those mentioned in the 
  paper "On the Style of Mechanical Proving" by ISWB Prasetya. The paper is in
  the proceeding of HUG93.

      Author      : Wishnu Prasetya
      Date        : July 1993
      Affiliation : Dept. of Computer Science
                    Utrecht University
                    the Netherlands
      Email       : wishnu@cs.ruu.nl
  
----------------------------------------------------------------------------%

loadf `DerLem` ;;
new_theory `try` ;;

% -------- Example 1 ------------------------------------------------

Let (PLUS,d,NU,<<) be an algebra such that:
   
    (0) NU is an involution:      NU(NU x) = x
    (1) Unit Design Equation:     d << x PLUS y  =  NU x << y
    (2) PLUS is commutative:      x PLUS y = y PLUS x

prove that x<<y  =  NU y << NU x

---------------------------------------------------------------------%

let RelType = ":*dom -> *dom -> bool" ;;
let OPType = ":*dom->*dom->*dom" ;;
new_infix (`<<`,RelType) ;;
new_infix (`PLUS`,":^OPType") ;;
new_constant (`NU`,":*dom->*dom") ;;
new_constant (`d`,":*dom") ;;

%--------------------------------------------------------------------------

       A typical HOL proof of NU Inversion is the following

---------------------------------------------------------------------------%

let UNIT_DE = "!(x:*dom) y. d << (x PLUS y) = (NU x) << y" ;;
let PLUS_COM = "!(x:*dom) y. x PLUS y = y PLUS x" ;;
let NU_INVO = "!x:*dom. NU(NU x) = x" ;;

let thm = TAC_PROOF
   (([UNIT_DE; PLUS_COM; NU_INVO], 
     "!x (y:*dom). x<<y = (NU y) << (NU x)"),
     REWRITE_TAC [SYM(SPEC_ALL (ASSUME UNIT_DE))]
     THEN ONCE_REWRITE_TAC[ASSUME PLUS_COM] 
     THEN REWRITE_TAC (map ASSUME [NU_INVO; UNIT_DE])) ;;

%------------------------------------------------------------------------

         Proof of NU Inversion in SUBGOAL_THEN style

------------------------------------------------------------------------%

let thm = TAC_PROOF
   (([UNIT_DE; PLUS_COM; NU_INVO], 
     "!x (y:*dom). x<<y = (NU y) << (NU x)"),
     REPEAT GEN_TAC 
     THEN SUBGOAL_THEN 
          "(x:*dom) << y  =  NU (NU x) << y"
          (\thm. REWRITE_TAC[thm]) 
     THENL [ REWRITE_TAC [ASSUME NU_INVO] ; ALL_TAC] 
     THEN SUBGOAL_THEN 
          "NU (NU (x:*dom)) << y  =  d << (NU x) PLUS y"
          (\thm. REWRITE_TAC[thm]) 
     THENL [ REWRITE_TAC [ASSUME UNIT_DE] ; ALL_TAC]
     THEN SUBGOAL_THEN 
          "(d:*dom) << ((NU x) PLUS y)  =  (NU y) << (NU x)"
          (\thm. REWRITE_TAC[thm]) 
     THEN  ONCE_REWRITE_TAC [ASSUME PLUS_COM]
           THEN REWRITE_TAC[ASSUME UNIT_DE]) ;;

%------------------------------------------------------------------------

     Proof of NU inversion in DERIVATION style

------------------------------------------------------------------------%

Set_Assumptions 
    [(`UNIT_DE`,  "!(x:*dom) y. d << (x PLUS y) = (NU x) << y") ;
     (`PLUS_COM`, "!(x:*dom) y. x PLUS y = y PLUS x") ;
     (`NU_INVO`,  "!x:*dom. NU(NU x) = x") ] ;;

BD "=:bool->bool->bool" "(x:*dom) << y" ;;

DERIVE("=:bool->bool->bool",
   "(NU (NU x)) << (y:*dom)",
   `HINT: NU is an involution`,
    REWRITE_TAC[RECALL `NU_INVO`]) ;; 

DERIVE("=:bool->bool->bool",
   "d << (NU x) PLUS (y:*dom)",
   `HINT: by Unit Design Equation`,
    REWRITE_TAC [RECALL `UNIT_DE`]) ;;

DERIVE("=:bool->bool->bool",
   "NU y << (NU (x:*dom))",
   `HINT: PLUS is commutative and Unit Design Equation`,
    ONCE_REWRITE_TAC [RECALL `PLUS_COM`]
    THEN REWRITE_TAC[RECALL `UNIT_DE`]) ;;


%---------- Example 2 ------------------------------------------------

We know that << is a transitive relation. 
Let (PLUS,e,NU) be such that:
   
    (0) e is the unit of PLUS: x PLUS e = x
    (1) NU is the right inverse operator: x PLUS (NU x) = e
    (2) PLUS is monotonic: x<<y implies 
             x PLUS z << y PLUS z and z PLUS x << z PLUS y
    (3) PLUS is associative: (x PLUS y) PLUS z = x PLUS (y PLUS z)

prove that (x PLUS y) PLUS (NU y) << y holds given that x<<y

----------------------------------------------------------------------%

new_constant (`e`,":*dom") ;;
let LL_TRANS = new_axiom (`LL_TRANS`, 
    "!a b (c:*dom). a<<b  /\  b<<c  ==>  a<<c") ;;

Set_Assumptions
   [(`unit`,"!x:*dom. x PLUS e = x") ;
    (`Rinv`,"!x:*dom. x PLUS (NU x) = e") ;
    (`PLUS_Mono`, "!(x:*dom) y z. x<<y ==> 
                   (x PLUS z) << (y PLUS z) /\
                   (z PLUS x) << (z PLUS y)") ;
    (`PLUS_Assoc`, "!(x:*dom) y z. 
                 ((x PLUS y) PLUS z) = (x PLUS (y PLUS z))") ;
    (`asm0`, "(x:*dom) << y") ] ;;

BD "<<:^RelType" "((x:*dom) PLUS  y) PLUS (NU y)" ;;

DERIVE ("<<:^RelType","((y:*dom) PLUS  y) PLUS (NU y)",
   `HINT: PLUS is monotonic`,
   SUBGOAL_THEN "((x:*dom) PLUS y) << (y PLUS y)"
           (\thm. ASSUME_TAC thm)
   THENL [RES_TAC THEN ASM_REWRITE_TAC[] ; ALL_TAC]
   THEN RES_TAC THEN ASM_REWRITE_TAC[]) ;;

DERIVE ("=:^RelType","(y:*dom) PLUS (y PLUS (NU y))",
   `HINT: PLUS is associative`,
   REWRITE_TAC [RECALL `PLUS_Assoc`]) ;;
   
DERIVE ("=:^RelType","y:*dom",
   `HINT: NU is the invertor and e is unit of PLUS`,
   REWRITE_TAC [RECALL `Rinv`; RECALL `unit`]) ;;


% -------- Example 3 ------------------------------------------------

given that |--> and unless satisfies the following

   (1) |--> is transitive
   (2) |--> is right monotonic
   (3) Cancelation Law:

            p |--> q OR r  ,  r |--> s
           ---------------------------
                   p |--> q OR s

   (4) PSP Law:

               p |--> q , r unless b
          ------------------------------
            p AND r |--> (q AND r) OR b

Then prove the following:

         p |--> q , b |--> c , c |--> q , a unless b
        ---------------------------------------------
                     p AND a |--> q

---------------------------------------------------------------------%

loadf `predicate` ;;
let Pred = ":*dom->bool" ;;
new_special_symbol `|-->` ;;
new_infix (`|-->`,":^Pred->^Pred->bool") ;;
new_infix (`unless`,":^Pred->^Pred->bool") ;;

let LT_TRANS = new_axiom(`LT_TRANS`,
    "!p q (r:^Pred). (p|-->q) /\ (q|-->r) ==> (p|-->r)") ;;

let LT_MONOTONIC = new_axiom(`LT_MONOTONIC`,
    "!p q (r:^Pred). (p|-->q) /\ (|== (q IMP r)) ==> (p|-->r)") ;;

let CANCELATION_LAW = new_axiom(`CANCELATION_LAW`,
    "!p q r (b:^Pred). (p|-->q OR r) /\ (q|-->b) ==> (p|-->b OR r)") ;;

let PSP_LAW = new_axiom(`PSP_LAW`,
    "!p q r (b:^Pred).
      (p|-->q) /\ (r unless b) ==> ((p AND r) |--> (q AND r) OR b)") ;;

Set_Assumptions 
    [(`asm0`,"(p:^Pred)|-->q") ;
     (`asm1`,"(b:^Pred)|-->c /\ c|-->q") ;
     (`asm2`,"(a:^Pred) unless b") ] ;;

LEMMA (`lem10`,"(b:^Pred)|-->q",
   `HINT: asm1, |--> is transitive`,
   UNDISCH_ALL_TAC THEN REPEAT STRIP_TAC
   THEN IMP_RES_TAC LT_TRANS) ;;

LEMMA (`lem20`,"((p:^Pred) AND a) |--> (q AND a) OR b",
   `HINT: asm0, asm2, PSP Law`,
   IMP_RES_TAC PSP_LAW) ;;

LEMMA (`lem30`,"((p:^Pred) AND a) |--> (q AND a) OR q",
   `HINT: lem10, lem20, Cancelation Law`,
   ONCE_REWRITE_TAC [pOR_SYM]
   THEN ASSUME_TAC (RECALL `lem10`)
   THEN ASSUME_TAC (ONCE_REWRITE_RULE [pOR_SYM] (RECALL `lem20`))
   THEN IMP_RES_TAC CANCELATION_LAW) ;;

LEMMA (`lem40`,"((p:^Pred) AND a) |--> q",
   `HINT: Lem30, |--> is monotonic`,
   SUBGOAL_THEN "|== (((q AND a) OR q) IMP (q:^Pred))"
       (\thm. ASSUME_TAC thm)
   THENL [pred_JADE_TAC 3; ALL_TAC]
   THEN ASSUME_TAC (RECALL `lem30`)
   THEN IMP_RES_TAC LT_MONOTONIC) ;;

let the_theorem = prove
  ("!p q a b (c:^Pred).
       (p|-->q) /\ (b|-->c) /\ (c|-->q) /\ (a unless b) 
       ==>
       ((p AND a) |--> q)",
   REPEAT STRIP_TAC
   THEN IMP_RES_TAC (GEN_RECALL `lem40`)) ;;

%------------------------------------------------------------------------

   DCG DCG DCG DCG DCG DCG DCG DCG DCG DCG DCG DCG DCG DCG DCG DCG DCG 

------------------------------------------------------------------------%

