/*
(C) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
*/

/*
	fasl_pass2.c
	DG-SPECIFIC

	fasl loader pass2 routines
*/

#include "../h/fasl.h"
#include "../h/fasl_global.h"

data_pass2()
{
	FAS_HDR_P	hdr_p;
	FAS_DATA_P	data_p;
	FAS_DICT_P	dict_p;

	int	not_over;	/* overwrite flag */
	short	*block_end;	/* end of this block */
	short	*rdata_p;	/* relocation data pointer */
	short	*p_addr;	/* partition start addr */
	short	*rdata_addr;	/* relocationed data addr */
	short	*base_p;	/* base pointer */
	short	*dword_p;	/* dictionaried data word pointer */
	short	data_len;	/* copy of data_words */
	short	base, repeat_count;
	short	reloc;		/* relocation operation */
	short	reloc_ex;	/* extended relocaton operation */

	/* initialize */
	hdr_p = (FAS_HDR_P)fas_buffp;
	if ((hdr_p->hdr_typ) && OVER_BIT)
		not_over = FALSE;
		else
		not_over = TRUE;
	block_end = (short *)fas_buffp + hdr_p->hdr_len;
	data_p = (FAS_DATA_P)(fas_buffp + FAS_HEADER_BLEN);
	if (datab_rev < 2)
		rdata_p = (short *)(data_p + 1) - 2;
		else
		rdata_p = (short *)(data_p + 1);
	data_len = data_p->data_words;
	if (data_len == 0) return;

	if (datab_rev < 2)
		repeat_count = 1;
		else
		repeat_count = data_p->data_repeat;
	base = data_p->data_base;

/*
	part_table_p = fasl_get_table(base);
	p_addr = (short *)(part_table_p->part_addr);
*/
	p_addr = fasl_get_addr(base);

	/* data relocation */
	reloc = (data_p->data_reloc) & RELOC_OP;
	reloc_ex = ((data_p->data_reloc) & RELOC_OP_EX) >> RELOC_OP_S;
	if (reloc != EX_RELOC) unexpect_reloc(reloc);

	base_p = &(data_p->data_base);
	dword_p = &(data_p->data_disp);
	relocation(reloc_ex, base_p, dword_p);
	rdata_addr = *((int *)dword_p);

	while(repeat_count-- > 0) {
/*	  if (not_over == TRUE)
	  	fasl_set_map(rdata_addr - fas_rstart, data_len,
				rdata_p, rdata_addr);		*/
	  /* block move data to alocated memory */
	  blockmove((char *)rdata_addr, (char *)rdata_p, data_len * 2);
	  dict_p = (FAS_DICT_P)(rdata_p + data_len);
				/* set to first dictionary */

	  while (dict_p < block_end) {	/* loop for each dictionary */
		reloc = (dict_p->dict_reloc) & RELOC_OP;
		reloc_ex = ((dict_p->dict_reloc) & RELOC_OP_EX)
							>> RELOC_OP_S;

/*		if ((reloc != EX_RELOC) && (reloc != BIT_RELOC)) */
		if (reloc != EX_RELOC)
			unexpect_reloc(reloc);

		/* set base pointer */
		base_p = &(dict_p->dict_base);
	  	/* set dictionaried data word pointer */
		if (datab_rev == 0)
			dword_p = p_addr + dict_p->dict_data;
			else		/* offset from partition */
			dword_p = rdata_addr + dict_p->dict_data;
					/* offset from data */
		/* relocate this data word */
		relocation(reloc_ex, base_p, dword_p);
		/* for next dictionary */
		dict_p = dict_p + 1;
	  }	/* end of while for each dictionary */

	  /* advance rdata_addr to relocate once more */
	  rdata_addr += data_len;
	}	/* end of while for repeat count */
}

ent_pass2()
{
	FAS_HDR_P	hdr_p;
	FAS_ENT_P	ent_p;
	FAS_ENTD_P	entd_p;

	short	name_len, base, reloc, reloc_ex;
	short	*base_p, *dword_p;
	long	disp;
	char	*name_ptr;
	char	namebuff[MAX_SYMBOL + 1];
	int	i, repeat;

	if (fas_routine_addr != 0) return;

	hdr_p = (FAS_HDR_P)fas_buffp;
	ent_p = (FAS_ENT_P)(hdr_p + 1);
	entd_p = (FAS_ENTD_P)(ent_p + 1);

	repeat = ent_p->ent_count;

	while (repeat-- > 0) {
	   name_len = (entd_p->entd_len) & L_MASK;
	   if (name_len < 4) goto NEXT;
	   name_ptr = (char *)fas_buffp + (entd_p->entd_ptr);
	   for (i=0; i < 4; i++)	/* compare first 4 bytes */
		namebuff[i] = *(name_ptr + i);
	   namebuff[i] = '\0';

	   if (strcmp(fas_routine_name, namebuff) == 0) goto FOUND_SYM;
				/* init routine name ? */

NEXT:
	   entd_p += 1;	/* advance for next */
	   continue;

FOUND_SYM:
	   /* We found the init routine's symbol. Relocate it. */

	   reloc = entd_p->entd_reloc & RELOC_OP;
	   reloc_ex = (entd_p->entd_reloc & RELOC_OP_EX) >> RELOC_OP_S;

	   if (reloc != EX_RELOC) unexpect_reloc(reloc);

	   base_p = &(entd_p->entd_base);
	   dword_p = &(entd_p->entd_disp);
	   relocation(reloc_ex, base_p, dword_p);

	   /* save init routine address */
	   fas_routine_addr = *((int *)dword_p);
	   break;
	   }	/* end of while */
}

fasl_set_map(sb, len, sp, dp)
int sb, len;
short *sp, *dp;
{
	int	i, mask;

/*
	while(len-- > 0) {
		i = sb / 32;
		mask = 1 << (31 - sb % 32);
		if ((fas_map[i] & mask) &&
		    (*(dp + sb) != *(sp + sb)))
			FEerror("Overwrite error", 0);
		fas_map[i] |= mask;
		sb++;
	}
*/
}

