/*
(c) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
Copying of this file is authorized to users who have executed the true and
proper "License Agreement for Kyoto Common LISP" with SIGLISP.
*/

/*
	unixtime.c
*/

#include "include.h"
#include <sys/types.h>

#if defined BSD || defined ULTRIX_MIPS
#include <sys/timeb.h>
#include <sys/times.h>
static struct timeb beginning;
#endif

#ifdef ATT
#include <sys/times.h>
long beginning;
#endif

#ifdef E15
#include <sys/times.h>
long beginning;
#endif

#ifdef DGUX


#endif

runtime()
{
	struct tms buf;

	times(&buf);
	return(buf.tms_utime * 1000/60);
}

object
unix_time_to_universal_time(i)
int i;
{
	object x;
	vs_mark;

	vs_push(make_fixnum(24*60*60));
	vs_push(make_fixnum(70*365+17));
	x = number_times(vs_top[-1], vs_top[-2]);
	vs_push(x);
	vs_push(make_fixnum(i));
	x = number_plus(vs_top[-1], vs_top[-2]);
	vs_reset;
	return(x);
}

Lget_universal_time()
{
	check_arg(0);
	vs_push(unix_time_to_universal_time(time(0)));
}

Lsleep()
{
	object z;
	
	check_arg(1);
	check_type_or_rational_float(&vs_base[0]);
	if (number_minusp(vs_base[0]) == TRUE)
		FEerror("~S is not a non-negative number.", 1, vs_base[0]);
	Lround();
	z = vs_base[0];
	if (type_of(z) == t_fixnum)
		sleep(fix(z));
	else
		for(;;)
			sleep(1000);
	vs_top = vs_base;
	vs_push(Cnil);
}

Lget_internal_run_time()
{
	struct tms buf;

	check_arg(0);
	times(&buf);
	vs_push(make_fixnum(buf.tms_utime));
}

Lget_internal_real_time()
{
#if defined BSD || defined ULTRIX_MIPS
	struct timeb buf;

	check_arg(0);
	ftime(&buf);
	vs_push(make_fixnum(((buf.time-beginning.time)*1000+
			     (buf.millitm-beginning.millitm))*60/1000));
#endif

#ifdef ATT
	check_arg(0);
	vs_push(make_fixnum((time(0) - beginning)*60));
#endif

#ifdef E15
	check_arg(0);
	vs_push(make_fixnum((time(0) - beginning)*60));
#endif

#ifdef DGUX


#endif
}

init_unixtime()
{
#if defined BSD || defined ULTRIX_MIPS
	ftime(&beginning);
#endif
#ifdef ATT
	beginning = time(0);
#endif
#ifdef E15
	beginning = time(0);
#endif
#ifdef DGUX

#endif

	make_si_special("*DEFAULT-TIME-ZONE*", make_fixnum(TIME_ZONE));
	make_constant("INTERNAL-TIME-UNITS-PER-SECOND", make_fixnum(60));

	make_function("GET-UNIVERSAL-TIME", Lget_universal_time);
	make_function("SLEEP", Lsleep);
	make_function("GET-INTERNAL-RUN-TIME", Lget_internal_run_time);
	make_function("GET-INTERNAL-REAL-TIME", Lget_internal_real_time);
}
