/*
(c) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
Copying of this file is authorized to users who have executed the true and
proper "License Agreement for Kyoto Common LISP" with SIGLISP.
*/

/*
	unixint.c
*/

#include "include.h"
#include <signal.h>

object SVinterrupt_enable;

sigalrm()
{
	if (interrupt_flag) {
		interrupt_flag = FALSE;
		terminal_interrupt(TRUE);
	}
}

sigint()
{
	if (!interrupt_enable || interrupt_flag) {
/*
		if (!interrupt_enable)
			fprintf(stderr, "\nInterrupt ignored.\n");
*/
		signal(SIGINT, sigint);
		return;
	}
	if (symbol_value(SVinterrupt_enable) == Cnil) {
		SVinterrupt_enable->s.s_dbind = Ct;
		signal(SIGINT, sigint);
		return;
	}
	interrupt_flag = TRUE;
	signal(SIGALRM, sigalrm);
	alarm(1);
	signal(SIGINT, sigint);
}

sigfpe()
{
	signal(SIGFPE, sigfpe);
	FEerror("Floating-point exception.", 0);
}

#if defined BSD || defined ULTRIX_MIPS
signal_catcher(sig, code, scp)
{
	char str[64];

	if (!interrupt_enable) {
		sprintf(str, "signal %d caught (during GBC)", sig);
		error(str);
	} else {
		vs_push(make_fixnum(sig));
		FEerror("Signal ~D caught.~%\
The internal memory may be broken.~%\
You should check the signal and exit from Lisp.", 1, vs_head);
	}
}

siLcatch_bad_signals()
{
	check_arg(0);

	signal(SIGILL, signal_catcher);
	signal(SIGIOT, signal_catcher);
	signal(SIGEMT, signal_catcher);
	signal(SIGBUS, signal_catcher);
	signal(SIGSEGV, signal_catcher);
	signal(SIGSYS, signal_catcher);
	vs_push(Ct);
}

siLuncatch_bad_signals()
{
	check_arg(0);

	signal(SIGILL, SIG_DFL);
	signal(SIGIOT, SIG_DFL);
	signal(SIGEMT, SIG_DFL);
	signal(SIGBUS, SIG_DFL);
	signal(SIGSEGV, SIG_DFL);
	signal(SIGSYS, SIG_DFL);
	vs_push(Ct);
}
#endif

init_interrupt()
{
	signal(SIGFPE, sigfpe);
	signal(SIGINT, sigint);
}

init_interrupt1()
{
	SVinterrupt_enable
	= make_si_special("*INTERRUPT-ENABLE*", Ct);
#if defined BSD || defined ULTRIX_MIPS
	make_si_function("CATCH-BAD-SIGNALS", siLcatch_bad_signals);
	make_si_function("UNCATCH-BAD-SIGNALS", siLuncatch_bad_signals);
#endif
}
