/*

	mipsearith.s -- extended arithmetic for MIPS R2000 processor
	Author: Arpita Datta  <ardatta@cs.wright.edu>
	Date  : October 12, 1989
	
	EXTENDED_MUL and EXTENDED_DIV perform 32 bit multiplication and
	division, respectively.


	EXTENDED_MUL(D,Q,R,HP,LP) 
	calculates D*Q+R and saves the result into the locations HP and LP.
	D, Q, and R are 32 bit non-negative integers and HP and LP are
	word addresses.  The word at LP will contain the lower 31 (not 32)
	bits of the result and its most significant bit is set 0. The word
	at HP will contain the rest of the result and its MSB is also set 0.

*/

	.text	
	.align	2

	.globl	extended_mul
 #
 #   	extended_mul(d, q, r, hp, lp)
 #   	unsigned int d, q, r;
 #   	unsigned int *hp, *lp
 #   	
	.ent	extended_mul 
extended_mul:
	.frame	$sp, 0, $31

	multu	$4, $5
	mfhi    $8
        mflo    $9
        addu    $10, $9, $6
        srl     $11, $10, 31
	sll     $10, 1
        srl     $10, 1
        sll     $8,  1        
        or      $12, $8, $11
	lw	$24, 16($sp)
        sw      $12, 0($7)
	sw	$10, 0($24)

	j	$31
	.end	extended_mul

/*

	EXTENDED_DIV(D,H,L,QP,RP)
	divides [H:L] by D and saves the quotient and the remainder into
	the locations QP and RP, respectively.  D, H, L are 32 bit
	non-negative integers and QP and RP are word addresses.  Here,
	[H:L]  means the 64 bit integer (imaginary) represented by H
	and L as follows.

	  63 62                  31 30                 0
	  |0|0|<lower 31 bits of H>|<lower 31 bits of L>|

	Although [H:L] is 64 bits, you can assume that the quotient is
	always represented as 32 bit non-negative integer.

*/
	.globl	extended_div

 #   
 #      extended_div(k, h, l, qp, rp)
 #      unsigned int k, h, l;
 #      unsigned int *qp, *rp
 #
	.ent	extended_div 2
extended_div:
	.frame	$sp, 0, $31

	sll	$6, 1
	li	$2, 31
loop:
	srl	$15, $6, 31
	sll	$5, 1
	or	$5, $15
	sll	$6, 1
	subu	$15, $5, $4
	bltz	$15, underflow
	move	$5, $15
	or 	$6, 1
underflow:
	subu	$2, 1
	bnez	$2, loop
	sw	$6, 0($7)
	lw	$7, 16($sp)
	sw	$5, 0($7)

	j	$31
	.end	extended_div


