/*
(c) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
Copying of this file is authorized to users who have executed the true and
proper "License Agreement for Kyoto Common LISP" with SIGLISP.
*/
/*
	bitop.c

	Sets and/or tests bits in the mark table.  The first 8 words of the
	Lisp data area have their mark bits in the byte location pointed to
	by MARK_TABLE, and the next 8 words in the next byte location,
	and so on.

	GET_MARK_BIT(X)
	Returns 1 if the mark bit for the word address X is on.  Otherwise,
	returns 0.

	SET_MARK_BIT(X)
	Sets on the mark bit for the word address X.

	GET_SET_MARK_BIT(X)
	Sets on the mark bit for the word address X, and returns 1 if the
	mark bit was previously on.  Returns 0 otherwise.

*/
#include "include.h"

#ifdef VAX

get_mark_bit(x)
int *x;
{
	asm("	ashl	$-2,4(ap),r2");
	asm("	ashl	$-3,r2,r3");
	asm("	bicl2	$-8,r2");
	asm("	clrl	r0");
	asm("	addl2	_mark_table,r3");
	asm("	bbc	r2,(r3),1f");
	asm("	incl	r0");
	asm("1:");
}

set_mark_bit(x)
int *x;
{
	asm("	ashl	$-2,4(ap),r2");
	asm("	ashl	$-3,r2,r3");
	asm("	bicl2	$-8,r2");
	asm("	addl2	_mark_table,r3");
	asm("	bbcs	r2,(r3),1f");
	asm("1:");
}

get_set_mark_bit(x)
int *x;
{
	asm("	ashl	$-2,4(ap),r2");
	asm("	ashl	$-3,r2,r3");
	asm("	bicl2	$-8,r2");
	asm("	clrl	r0");
	asm("	addl2	_mark_table,r3");
	asm("	bbcs	r2,(r3),1f");
	asm("	incl	r0");
	asm("1:");
}

#endif

#ifdef MC68K

get_mark_bit(x)
int *x;
{
	asm("	movl	a6@(8),d0");
	asm("	lsrl	#2,d0");
	asm("	movl	d0,d1");
	asm("	lsrl	#3,d1");
	asm("	movl	_mark_table,a0");
	asm("	btst	d0,a0@(0,d1:L)");
	asm("	sne	d0");
	asm("	andl	#1,d0");
}

set_mark_bit(x)
int *x;
{
	asm("	movl	a6@(8),d0");
	asm("	lsrl	#2,d0");
	asm("	movl	d0,d1");
	asm("	lsrl	#3,d1");
	asm("	movl	_mark_table,a0");
	asm("	bset	d0,a0@(0,d1:L)");
}

get_set_mark_bit(x)
int *x;
{
	asm("	movl	a6@(8),d0");
	asm("	lsrl	#2,d0");
	asm("	movl	d0,d1");
	asm("	lsrl	#3,d1");
	asm("	movl	_mark_table,a0");
	asm("	bset	d0,a0@(0,d1:L)");
	asm("	sne	d0");
	asm("	andl	#1,d0");
}

#endif

#ifndef NEWS
#ifdef MC68020

get_mark_bit(x)
int *x;
{

	asm("	movl	a6@(8),d0");
	asm("	lsrl	#2,d0");
	asm("	movl	d0,d1");
	asm("	lsrl	#3,d1");
	asm("	movl	_mark_table,a0");
	asm("	btst	d0,a0@(0,d1:L)");
	asm("	sne	d0");
	asm("	andl	#1,d0");

}

set_mark_bit(x)
int *x;
{

	asm("	movl	a6@(8),d0");
	asm("	lsrl	#2,d0");
	asm("	movl	d0,d1");
	asm("	lsrl	#3,d1");
	asm("	movl	_mark_table,a0");
	asm("	bset	d0,a0@(0,d1:L)");
}

get_set_mark_bit(x)
int *x;
{

	asm("	movl	a6@(8),d0");
	asm("	lsrl	#2,d0");
	asm("	movl	d0,d1");
	asm("	lsrl	#3,d1");
	asm("	movl	_mark_table,a0");
	asm("	bset	d0,a0@(0,d1:L)");
	asm("	sne	d0");
	asm("	andl	#1,d0");
}

#endif
#endif

#ifdef ULTRIX_MIPS
extern unsigned int *mark_table;

#define DATASTART	0x10000000

get_mark_bit(x)
unsigned int x;
{

    int y;

    y = (mark_table[x - DATASTART  >> 7] >> ((x - DATASTART >> 2)
					     & 0x1f) & 1);
    return (y);
}

set_mark_bit(x)
unsigned int x;
{

    	mark_table[x - DATASTART >> 7] |= 1 << ((x - DATASTART >> 2) &
						0x1f);
}

get_set_mark_bit(x)
unsigned int x;
{
	int y;

	y = get_mark_bit(x);
	set_mark_bit(x);
	return(y);
}

#endif

#ifdef ATT3B2

get_mark_bit(x)
int *x;
{
	asm("	subw3	&0x80800000,0(%ap),%r1"); /* R1 <= address offset */
	asm("	lrsw3	&2,%r1,%r1");		/* R1 <= bit offset */
	asm("	lrsw3	&3,%r1,%r0");		/* R0 <= byte offset */
	asm("	andw2	&0x7,%r1");
	asm("	addw2	mark_table, %r0");
	asm("	movb	0(%r0),%r0");		/* R0 <= table entry */
	asm("	lrsw3	%r1,%r0,%r0");
	asm("	andw2	&1,%r0");		/* LSB(R0) = the bit */
}

set_mark_bit(x)
int *x;
{
	asm("	subw3	&0x80800000,0(%ap),%r0"); /* R0 <= address offset */
	asm("	lrsw3	&2,%r0,%r0");		/* R0 <= bit offset */
	asm("	lrsw3	&3,%r0,%r1");		/* R1 <= byte offset */
	asm("	andw2	&0x7,%r0");
	asm("	llsw3	%r0,&1,%r0");		/* R0 <= mask */
	asm("	addw2	mark_table,%r1");
	asm("	orb2	%r0,0(%r1)");
}

get_set_mark_bit(x)
int *x;
{
	register int *r8;

	asm("	subw3	&0x80800000,0(%ap),%r1"); /* R1 <= address offset */
	asm("	lrsw3	&2,%r1,%r1");		/* R1 <= bit offset */
	asm("	lrsw3	&3,%r1,%r2");		/* R2 <= byte offset */
	asm("	andw2	&0x7,%r1");
	asm("	addw2	mark_table,%r2");
	asm("	movb	0(%r2),%r0");		/* R0 <= table entry */
	asm("	llsw3	%r1,&1,%r8");		/* R8 <= mask */ 
	asm("	orb2	%r8,0(%r2)");		/* set */
	asm("	lrsw3	%r1,%r0,%r0");
	asm("	andw2	&1,%r0");		/* get */
}

#endif

#ifdef NS32K




































#endif

#ifdef S3000

extern int *mark_table;

get_mark_bit(x)
int x;
{
	int y;

	y = (*(mark_table+(x/4/32)) >> (x/4%32)) & 1;
	return(y);
}

set_mark_bit(x)
int x;
{
	int y;

	y = 1 << (x/4%32);
	y = (*(mark_table+(x/4/32))) | y;
	*(mark_table+ (x/4/32))=y;
}

get_set_mark_bit(x)
int x;
{
	int y;

	y = get_mark_bit(x);
	set_mark_bit(x);
	return(y);
}

#endif

#ifdef IBMRT








































































#endif

#ifdef NEWS

get_mark_bit(x)
int *x;
{
	asm("	move.l	(8,fp),d0");
	asm("	lsr.l	#2,d0");
	asm("	move.l	d0,d1");
	asm("	lsr.l	#3,d1");
	asm("	move.l	_mark_table,a0");
	asm("	btst	d0,0(a0,d1.l)");
	asm("	sne	d0");
	asm("	and.l	#1,d0");
}

set_mark_bit(x)
int *x;
{
	asm("	move.l	(8,fp),d0");
	asm("	lsr.l	#2,d0");
	asm("	move.l	d0,d1");
	asm("	lsr.l	#3,d1");
	asm("	move.l	_mark_table,a0");
	asm("	bset	d0,0(a0,d1.l)");
}

get_set_mark_bit(x)
int *x;
{
	asm("	move.l	(8,fp),d0");
	asm("	lsr.l	#2,d0");
	asm("	move.l	d0,d1");
	asm("	lsr.l	#3,d1");
	asm("	move.l	_mark_table,a0");
	asm("	bset	d0,0(a0,d1.l)");
	asm("	sne	d0");
	asm("	and.l	#1,d0");
}

#endif
