/* ========================================================================= */
/* Crude filter for GTT. This performs the following functions:              */
/*                                                                           */
/* o Translates the `:...` and `...` into type and term parsers,             */
/*   respectively, applied to appropriately escaped strings.                 */
/*                                                                           */
/* o Inserts "let it = " before toplevel phrases which don't start           */
/*   with a declaration, to compensate for the lack of "it" in               */
/*   CAML Light.                                                             */
/*                                                                           */
/* It's a bit crude. It can be thrown by comments; in particular             */
/* comments don't nest! This could be fixed, but who cares?                  */
/* ========================================================================= */

#include <stdio.h>
#include <signal.h>

int newphrase = 1;

#define rdch() (c = getchar(), c=='\n' ? (putchar(c), fflush(stdout)) : 0)

int main(void)
{ int c;
  signal(SIGINT,SIG_IGN);
  rdch();
  while (c != EOF)
   { if (newphrase)
      { if (isspace(c))
         { rdch();
           continue;
         }
        if (c=='(')
         { rdch();
           if (c=='*')
            { do
               { do rdch(); while (c!='*');
                 do rdch(); while (c=='*');
               }
              while (c!=')');
              rdch();
              continue;
            }
           else
            { printf("let it = (");
              newphrase = 0;
              continue;
            }
         }
        newphrase = 0;
        if (c=='l')
         { rdch();
           if (c=='e')
            { rdch();
              if (c=='t')
               { rdch();
                 if (isspace(c))
                    printf("let ");
                 else
                    printf("let it = let");
               }
              else
                 printf("let it = le");
            }
           else
              printf("let it = l");
         }
        else if (c=='t')
         { rdch();
           if (c=='y')
            { rdch();
              if (c=='p')
               { rdch();
                 if (c=='e')
                  { rdch();
                    if (isspace(c))
                      printf("type ");
                    else
                       printf("let it = type");
                  }
                 else
                    printf("let it = typ");
               }
              else
                 printf("let it = ty");
            }
           else
              printf("let it = t");
         }
        else if (c=='#')
         { putchar('#');
           rdch();
           continue;
         }
        else
           printf("let it = ");
      }
     newphrase = 0;
     if (c==';')
      { putchar(c);
        rdch();
        if (c==';')
         { putchar(c);
           do rdch(); while (isspace(c));
           newphrase = 1;
           continue;
         }
      }
     if (c == '`')
      { rdch();
        if (c == ':')
         { printf("(Y\"");
           rdch();
         }
        else
           printf("(X\"");
        while (c != '`' && c != EOF)
         { if (c == '\\')
             putchar('\\');
           if (c!='\n') putchar(c);
           rdch();
         }
        if (c == '`')
         { printf("\")");
           rdch();
         }
      }
     else
      { if (c!='\n') putchar(c);
        rdch();
      }
   }
  return(0);
}
