 #########################################################################
 #                                                                       #
 # Copyright (C) 1993, 1994 by General Electric Company.  All rights     #
 # reserved.                                                             #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File:	static.tcl
#
# Description:
#	`static' command for Tcl.
#
# Acknowledgement:
#	This file was kindly provided by Karl Lehenbauer of
#	NeoSoft Communications Services.

 # static.tcl,v 1.1.1.1 1994/12/07 10:17:30 donald Exp
 # /homes/drs1004/repository/tkaux/static.tcl,v
 # static.tcl,v
# Revision 1.1.1.1  1994/12/07  10:17:30  donald
# First import after some small chanegs.
#
 # Revision 1.11  1994/10/27  18:29:42  kennykb
 # Release 2.0 -- 10-27-94.  To be uploaded to archive sites.
 #
 # Revision 1.10  1994/01/04  19:31:39  kennykb
 # Updated to Karl Lehenbauer's version of 16 Nov 1993 00:26:44 UTC.
 # Deleted extraneous rubbish that got packaged at the end of the file.
 #
 # Revision 1.9  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.8  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.7  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.6  1993/10/20  19:04:11  kennykb
 # Repaired copyright notice so that it doesn't look like structured commentary.
 #
 # Revision 1.5  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.4  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.3  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.2  1993/07/21  19:44:36  kennykb
 # Finished cleaning up structured commentary.
 #
 # Revision 1.1  1993/06/03  13:21:35  kennykb
 # Initial revision
 #

# Procedure:	static
#
# Synopsis:
#	Declare one or more static variables.
#
# Usage:
#c	static ?variable?...
#
# Parameters:
#c	variable
#		Name of a static variable
#
# Return value:
#	None.
#
# Description:
#	`static' declares that a given variable or set of variables persists
#	between invocations of the procedure that contains it.  It
#	does so by making the variable global, but prepending to it the
#	name of the containing procedure plus a colon.

proc static {args} {
    set procName [lindex [info level -1] 0]
    foreach varName $args {
	uplevel 1 "upvar #0 static_vars($procName:$varName) $varName"
    }
}
