#############################################################################
#   LoadCode.tcl,v 1.12 1995/04/04 16:39:16 drs1004 Exp
#    Copyright (C) 1994  Donald Syme
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 1, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    Contact Details:
#	Donald Syme
#	The Computer Laboratory
#	New Musuems Site
#	Pembroke St.
#	Cambridge U.K. CB2 3QG
#
#	email: Donald.Syme@cl.cam.ac.uk
#
#############################################################################

#----------------------------------------------------------------------------
#
# Exported functions: (Package related)
#	TkHolSlave::InitialisePackage
#	TkHolSlave::ProcessArgs
#	TkHolSlave::ShutdownPackage
#
#----------------------------------------------------------------------------


#----------------------------------------------------------------------------
# TkHolSlave::ProcessArgs
#
#----------------------------------------------------------------------------


proc TkHolSlave::ProcessArgs { argc argv } {
	global TkHolSlave_flags 
	global gui_flags
	global HolHelp_flags

	if [info exists TkHolSlave_flags(default_hol)] {
	    set default_hol $TkHolSlave_flags(default_hol)
	} else {
	    set default_hol "hol88"
	}


	auto_load Preferences_Add
	if {[llength [info commands Preferences_Add]]==1} {
    	    Preferences_Add "HOL Session Controls" "Preferences related to how the underlying HOL is run are set here.  Most changes to these options will only take effect after you restart $gui_flags(title). " \
	 	[list \
		    [list TkHolSlave_flags(hol) tkHolSlaveHol $default_hol "HOL executable" "The HOL executable to use at startup.  This may be overriden by the -hol command line option."] \
		    [list TkHolSlave_flags(holtype_strategy) tkHolSlaveHoltype [list CHOICE infer hol88 hol90] "HOL executable type" "The method by which $gui_flags(title) determines the type of the HOL executable being used.  If the value is \"infer\" then $gui_flags(title) will try to infer the type from the name of the HOL executable."] \
		    [list TkHolSlave_flags(prompt_strategy) tkHolSlavePrompt "" "HOL prompt" "The (primary) prompt to use for the HOL session.  This string should be one unlikely to appear in the output from a normal HOL session as $gui_flags(title) needs to detect it in the HOL output.  If the value is empty then $gui_flags(title) will choose a prompt for you."] \
		    [list TkHolSlave_flags(secondaryprompt_strategy) tkHolSlaveSecondaryPrompt "" "HOL90 secondary prompt" "The (secondary) prompt to use for the HOL session when running HOL90.  This string should be one unlikely to appear in the output from a normal HOL session as $gui_flags(title) needs to detect it in the HOL output.  If the value is empty then $gui_flags(title) will choose a secondary prompt for you."] \
    		    [list TkHolSlave_flags(trace) tkHolSlaveTrace OFF "HOL tracing" "Whether to trace the hidden input/output to and from the HOL session."] \
    		    [list TkHolSlave_flags(stdio) tkHolSlaveStdio ON "Mimic HOL stdio" "Whether to mimic the stdio of a HOL session from the stdin/stdout of\nthis program."] \
		    [list TkHolSlave_flags(libraries) tkHolSlaveLibraries "" "Initial HOL libraries" "Libraries to load into HOL at startup.  An empty value means no theories are loaded.  Libraries can also be loaded using \"load_library\" or the -library command line flag."] \
		    [list TkHolSlave_flags(initial_theory) tkHolSlaveTheory "" "Initial HOL theory" "A theory to load into HOL at startup.  An empty value means no theory is loaded. Initial theories can also be given using \"load_theory\" or the -theory command line flag."] \
	     ]

    	    Preferences_Add "Logging Interactions" "Preferences related to logging your interactions with HOL are set here." \
		[list \
    		    [list TkHolSlave_flags(log) tkHolSlaveLog ON "Log interactions" "Whether to log interactions with the HOL session which change the state of the session.  This is similar to constructing a script of the activity within a session.  Only interactions from the interface which do not cause errors are recorded.  All input from the stdin is recorded."] \
    		    [list TkHolSlave_flags(logfile) tkHolSlaveLogFile "./log.ml" "Log File" "The file in which to record interactions should logging be turned on.  A change to this value takes effect immediately."] \
	    	]				 
		
    	}


	for {set arg 0} {$arg < $argc} {incr arg} {
	    switch -- [lindex $argv $arg] -trace {
	        set TkHolSlave_flags(trace) 1 
	    } -initialprompt {
	        set TkHolSlave_flags(initialprompt) 1 
	    } -prompt {
	        set TkHolSlave_flags(prompt_strategy) 1 
	    } -hol {
		incr arg
	        set TkHolSlave_flags(hol) [lindex $argv $arg] 
	    } -holtype {
		incr arg
	        set TkHolSlave_flags(holtype_strategy) [lindex $argv $arg] 
	    } -stdio {
		incr arg
	        set TkHolSlave_flags(stdio) [lindex $argv $arg] 
	    } -theory {
		incr arg
	        set TkHolSlave_flags(initial_theory) [lindex $argv $arg] 
	    } -library {
		incr arg
	        lappend TkHolSlave_flags(libraries) [lindex $argv $arg] 
	    }
	}
}


#----------------------------------------------------------------------------
#
# TkHolSlave::InitialisePackage
#
# 1. Turns logging of the HOL session on/off depending on whether
# stdin/stdout are being used.
#
# 2. Determines the type of the hol session
#
# 3. Sets the value of the initial prompt in the global variable
# hol_prompt.  This gets changed as soon as the prompt is itself 
# changed in Slave::Create.
#
# 4. Creates the HOL slave.
#
# 5. Sets up "expect" to detect input on the stdin and pass it 
# across to the HOL session using TkHolSlave::read_stdin (see below).
#----------------------------------------------------------------------------

proc TkHolSlave::InitialisePackage { args } {
        global TkHolSlave_flags 
	global gui_flags
	
	# log_user is an Expect command
	exp_log_user $TkHolSlave_flags(stdio)

#	exp_internal 1
	# Try to determine if we're using hol90 or hol88 by looking
	# at the name of the executable.  If it contains neither "hol88"
	# or "hol90" assume we are using hol88.
	
	switch -- $TkHolSlave_flags(holtype_strategy) {
	   infer {
	      switch -glob -- $TkHolSlave_flags(hol) *hol88* {
	        set TkHolSlave_flags(holtype) hol88
	      } *hol90* {
	        set TkHolSlave_flags(holtype) hol90
	      } default {
	        puts stderr "\nNote: $gui_flags(title) couldn't automatically determine the HOL type of  $TkHolSlave_flags(hol) so $gui_flags(title) is assuming it's hol88.  Use \"-holtype hol90\" if this is wrong.\n"
	        set TkHolSlave_flags(holtype) hol88
	      }
	   } hol88 {
	        set TkHolSlave_flags(holtype) hol88	      
	   } hol90 {
	        set TkHolSlave_flags(holtype) hol90
	   } default {
	        puts stderr "\n$gui_flags(title) internal error - strange value for $TkHolSlave_flags(holtype_strategy).  Assuming holtype is hol88."
	        set TkHolSlave_flags(holtype) hol88	      
	   }
	}
	set TkHolSlave_flags(hol88) 0
	set TkHolSlave_flags(hol90) 0
	switch -- $TkHolSlave_flags(holtype) {
	   hol88 {
	        set TkHolSlave_flags(hol88) 1
	   } 
	   hol90 {
	        set TkHolSlave_flags(hol90) 1
	   } 
	}
	
	if {[hol90] && $TkHolSlave_flags(logfile)=="./log.ml"} {
	    set TkHolSlave_flags(logfile) ./log.sml
	}
	
	# Create the slave session.

        TkHolSlave::Create $TkHolSlave_flags(hol)

	TkHolSlave::establish_stdin_processor

}


proc TkHolSlave::ShutdownPackage { } {
	TkHolSlave::Destroy
}


#----------------------------------------------------------------------------
# TkHol stdin processing apparatus
#
# TkHolSlave::establish_stdin_processor
#
# 	Set up expect to detect input on our stdin.  Input is
# 	read line by line and is buffered in the variable 
# 	stdin_buffer.  The input is sent across to the
# 	slave when it is not "busy".  At the moment this is
# 	detected by looking at the value of the global
# 	variable "busy", which is used to indicate
# 	that the TkTcl session is doing something.
#
# TkHolSlave::process_stdin
#
# 	Called after expect has 
# 	read a line of input from the stdin.  It adds the input 
# 	to the buffer in "stdin_buffer" then executes 
# 	TkHolSlave::try_to_flush_stdin_buffer
#
# TkHolSlave::try_to_flush_stdin_buffer
#
# 	First checks if the Tk session is "busy" (ie. in the middle of doing
# 	some processing).  If it is then it schedules another
#	attempt to flush the buffer in 1 second.  If it is not busy
# 	then it sends any buffered input across to the slave session.
# 	The input is sent line by line.  For each line it waits for the major
# 	or minor HOL prompt to appear.
#
# 	It also analyses the output from the HOL session looking for lines
# 	of tcl code to execute.  The tcl code is then executed after
#	all the input on the stdin has been executed.
#
# TkHolSlave::stdin_eof
#
#	Called when a end-of-file occurs on the stdin.  The Tk process
#	is terminated, but only after calling 
#	TkHolSlave::try_to_flush_stdin_buffer.
#
#----------------------------------------------------------------------------


proc TkHolSlave::establish_stdin_processor { } {
	global TkHolSlave_flags
	if {$TkHolSlave_flags(stdio)} {
	    global user_spawn_id
	    expect_background {
		-i $user_spawn_id -re "\[^\n\]*\n" {
		    TkHolSlave::process_stdin $expect_out(buffer)
		}
		-i $user_spawn_id eof {
		    TkHolSlave::stdin_eof
		}
	    }
	} 
}


proc TkHolSlave::process_stdin { input } {
	global stdin_buffer
	lappend stdin_buffer $input
	TkHolSlave::try_to_flush_stdin_buffer
}



proc TkHolSlave::try_to_flush_stdin_buffer { } {
	global expect_out
	global busy
	global feedback
	global stdin_buffer 
	global TkHolSlave_flags

	if ![info exists stdin_buffer] { return }
	if {$busy > 0} { 
	    after 1000 TkHolSlave::try_to_flush_stdin_buffer
	    return 
	}

	incr busy 
	set feedback [list quick "Executing ML code..."]
	TkHolSlave::SIGINT_effects_slave
	set buffer $stdin_buffer
	unset stdin_buffer
	if $TkHolSlave_flags(log) {
	    catch {
	        set f [open $TkHolSlave_flags(logfile) a+]
	        foreach stdin_line $buffer {
	            puts -nonewline $f $stdin_line
	        }
	        close $f
	    }
	}
	foreach stdin_line $buffer {
	    exp_send $stdin_line

	    set timeout -1
	    set delayed_executions ""
      	    while 1 {
	        if $TkHolSlave_flags(hol88) {
		    eval expect [EXPECT_TCL_SEQUENCE] [list -- [hol_prompt] break]
		}
	        if $TkHolSlave_flags(hol90) {
		    global hol_secondary_prompt
		    eval expect [EXPECT_TCL_SEQUENCE] [list -- [hol_prompt] break] [list -- $hol_secondary_prompt break]
		}
	    }
	    foreach delayed_execution $delayed_executions {
	        if [catch {eval $delayed_execution} err] {
		    incr busy -1
		    error $err
		}
	    }
	}
	expect *

	TkHolSlave::SIGINT_effects_master
	incr busy -1
}

proc TkHolSlave::stdin_eof { } {
	TkHolSlave::try_to_flush_stdin_buffer
	exit
}



