


proc TkHelp::ProcessArgs { argc argv } {
	global gui_flags
	global TkHelp_flags

	if {[llength [info commands Preferences_Add]]==1} {
    	    Preferences_Add "Running Mosaic" "Options related to running your WWW Browser are specified here." \
	 	[list \
		    [list TkHelp_flags(wwwBrowser) wwwBrowser "Mosaic" "WWW Browser" "This is the WWW (World Wide Web) browser that $gui_flags(title) uses to display the HOL help pages.  The URL of the page to be displayed is appended to the given command before execution."] \
		    [list TkHelp_flags(cooptMosaic) cooptMosaic OFF "Co-opt a running Mosaic" "If this is on then TkHolWorkbench will make use of a running Mosaic session instead of spawning a new Mosaic process when a help page is requested."] \
		    [list TkHelp_flags(psCommand) psCommand "/bin/ps -x" "Process Lookup Command" "This command is needed if the option to co-opt any existing Mosaic process is selected. The default value will nearly always be correct."] \
		    [list TkHelp_flags(killCommand) killCommand "/bin/kill" "Process Signal Sender" "This command is needed if the above option to co-opt any existing Mosaic process is selected. The default value will nearly always be correct."] \
	     ]
    	}

}


# NOTE: Mosaic can be controlled by remote control using SIGUSR1.  See
# the entry under the omsaic help pages for more details.  Netscape
# cannot be controlled in this way as far as I can tell.
#
# Firstly look for a mosaic processes if the option has been
# specified .
#
# Next reuse any previous mosaic process or the one just found,
# if possible.
#
# If this was not possible or failed, spawn off a new mosaic process.
#
# NOTE: All this must work for WWW browsers that are not Mosaic (and
# do not support the use of SIGUSR1) as well.


proc TkHelp::www_invoke { url } {
	global TkHelp_flags
    	global feedback
	global busy
	incr busy

	if {![info exists TkHelp_flags(www_pid)] && $TkHelp_flags(cooptMosaic) && [string match *osaic* $TkHelp_flags(wwwBrowser)]} {
	    if [catch {set processes [split [eval exec $TkHelp_flags(psCommand)] \n]} err] {
	        errormessage .error $err; incr busy -1; return
	    }
	    set psindex [lsearch -glob $processes *osaic*]
	    if {$psindex!=-1} {
		set TkHelp_flags(www_pid) [lindex [lindex $processes $psindex] 0]
	    }
	}
	if {[info exists TkHelp_flags(www_pid)] && [string match *osaic* $TkHelp_flags(wwwBrowser)]} {
	    if [catch {
		    set f [open /tmp/Mosaic.$TkHelp_flags(www_pid) w]
		    puts $f "newwin"
		    puts $f $url
		    close $f
		    eval exec $TkHelp_flags(killCommand) [list -USR1 $TkHelp_flags(www_pid)]
	    }] {
		unset TkHelp_flags(www_pid)
	    }
	}
	if ![info exists TkHelp_flags(www_pid)] {
	    set feedback [list {} "Spawning $TkHelp_flags(wwwBrowser)"]
	    if [catch {set TkHelp_flags(www_pid) [eval exec $TkHelp_flags(wwwBrowser) [list $url] &]} err] {
	    	errormessage .error $err; incr busy -1; return
	    }
	    exec /bin/sleep 2
	}
 	incr busy -1
}

