#----------------------------------------------------------------------------
# WIDGET CLASS SpecifyFixitiesBox
#
#	A box containing items specifying the fixities for a set
#	of constructors.
#
#	The box does not destroy itself.  It sets a global variable
#	which may be traced by trace or widget_waitVariable or a similar
#	mechanism.
#
# CONFIGURATION OPTIONS
#
#	-header
#		Some text printed at the top of the box as a message.
#
#	-constructors
#
#		A list of constructors whose fixities are to be specified.
#
#	-resultsvariable
#
#		This variable is set when either the OK or Cancel
#		buttons are pressed.  It is set to a list, the
#		first element of which is the button pressed.  The
#		remaining elements are the fixities specified.
#
# WIDGET OPERATIONS
#
#	None. 
#
# LIMITATIONS
#
#	The widget may not be manipulated or reconfigured afer 
#	creation.  The widget is not a first classs widget.
#
# EXAMPLE
#
#	modalDialog transient SpecifyFixitiesBox $w.save \
		-header "Select the fixities for the constructors:" \
		-resultsvariable vals($w,waiter) \
		-constructors [list LEAFY NODEY]
#	widget_waitVariable vals($w,waiter)
#	modalDialog.end $w.save
#	switch -- [lindex $vals($w,waiter) 0] Ok { ... } Cancel { ... }
#----------------------------------------------------------------------------


option add *SpecifyFixitiesBox.header "" widgetDefault
option add *SpecifyFixitiesBox.resultsvariable results widgetDefault


proc SpecifyFixitiesBox { w args } {
	global vals 
	global gui_flags

	for {set i 0} {$i<[llength $args]} {incr i} {
	    switch -- [lindex $args $i]  -header {
	        incr i
	        set header [lindex $args $i]
	    } -resultsvariable {
	        incr i
	        set vals($w,resultsvariable) [lindex $args $i]
	    } -constructors {
	        incr i
	        set vals($w,constructors) [lindex $args $i]
	    } default {
	    	error "unrecognized arg [lindex $args $i]"
	    }
	}
	frame $w -class SpecifyFixitiesBox
	if ![info exists header] { set header [option get $w header Header] }
	if ![info exists resultsvariable] { set resultsvariable [option get $w resultsvariable ResultsVariable] }

	pack [frame $w.controls] -side top
	pack [fontcheck focusable button $w.controls.ok \
		-width 6 \
		-text Ok \
		-command "SpecifyFixitiesBox::Ok $w" \
	 	-font $gui_flags(font,buttons)] \
	    -side left \
	    -padx 10
	pack [fontcheck focusable button $w.controls.cancel \
		-width 6 \
		-text Cancel \
		-command "set $vals($w,resultsvariable) Cancel" \
		-font $gui_flags(font,buttons)] \
	    -side left \
	    -padx 10

	pack [frame $w.options] -side top
	pack [label $w.options.header \
		-text $header \
		-font $gui_flags(font,labels)] \
	    -side top -padx 10
	set i 0
	foreach constructor $vals($w,constructors) {
	    pack [frame $w.options.c$i] -side top -pady 5 -padx 10
	    pack [frame $w.options.c$i.choices -borderwidth 2 -relief sunken] -side right -pady 5 -padx 10
	    pack [frame $w.options.c$i.choices.r -borderwidth 2] -side right
	    pack [frame $w.options.c$i.choices.l -borderwidth 2] -side right
	    pack [fontcheck focusable radiobutton $w.options.c$i.choices.l.prefix \
		-text "Prefix" \
		-variable vals($w,$constructor,fixity) \
		-value Term.Prefix \
		-font $gui_flags(font,buttons) \
		-relief flat -anchor w] -fill x
	    pack [fontcheck focusable radiobutton $w.options.c$i.choices.r.infix2 \
		-text "Infix (2)" \
		-variable vals($w,$constructor,fixity) \
		-value {Term.Infix 2} \
		-font $gui_flags(font,buttons) \
		-relief flat -anchor w] -fill x
	    pack [fontcheck focusable radiobutton $w.options.c$i.choices.r.infix3 \
		-text "Infix (3)" \
		-variable vals($w,$constructor,fixity) \
		-value {Term.Infix 3} \
		-font $gui_flags(font,buttons) \
		-relief flat -anchor w] -fill x
	    pack [fontcheck focusable radiobutton $w.options.c$i.choices.l.binder \
		-text "Binder" \
		-variable vals($w,$constructor,fixity) \
		-value {Term.Binder} \
		-font $gui_flags(font,buttons) \
		-relief flat -anchor w] -fill x
	    pack [fontcheck label $w.options.c$i.name \
		-font $gui_flags(font,labels) \
		-text "Fixity for $constructor:"] \
	    -side left
	    set vals($w,$constructor,fixity) Term.Prefix
	    incr i
	}

	wm protocol [winfo toplevel $w] WM_DELETE_WINDOW "set $vals($w,resultsvariable) Cancel"
	bind $w <Destroy> "unset_vals_for_widget $w"
	focus_goToFirst $w.controls
	return $w
}




proc SpecifyFixitiesBox::Ok { w } {
	global vals
	set result Ok
	foreach constructor $vals($w,constructors) {
	    lappend result $vals($w,$constructor,fixity)
	}
	upvar #0 $vals($w,resultsvariable) var
 	set var $result
}



