
structure CurrentTheoryNotification : CurrentTheoryNotification_sig = 
struct
	type client = 
		string * 
		(string -> unit) *	(* called when chrrent theory change *)
		(string -> unit) *	(* called when new parent added to current theory *)
		(bool -> unit);		(* called when current theory mode change *)

	fun mk_client x = (x:client);

	val notification_list = ref []: (client list) ref;


	fun add_client client =
		(notification_list := 
			(append [client] (! notification_list));
		());

	fun remove_client clientname =
		(notification_list := 
		    filter ( fn (cl,_,_,_) => not(cl = clientname)) (! notification_list);
		());
	
	

	fun load_theory th =
	        (Theory.load_theory th;
		map ( fn  (_,client,_,_) => client (current_theory())) (! notification_list); 
	 	());

	fun new_theory th =
	        (Theory.new_theory th;
		map ( fn  (_,client,_,_) => client (current_theory())) (! notification_list); 
		());

	fun extend_theory th =
	        (if (th = current_theory()) then
	             (Theory.extend_theory th;
		     map ( fn  (_,_,_,client) => client (draft_mode())) (! notification_list))
	         else
		     (Theory.extend_theory th;
	             map ( fn  (_,client,_,_) => client (current_theory())) (! notification_list)); 
	         ());

	fun close_theory th =
	        (Theory.close_theory th;
		map ( fn (_,_,_,client) => client (draft_mode())) (! notification_list); 
		());


	fun new_parent th =
	         (Theory.new_parent th;
		   map ( fn (_,_,client,_) => client (current_theory())) (! notification_list); 
	         ());
	 
	fun load_library spec = 		                    
	    let val old_parents = parents "-"			
	             val old_current = current_theory() in		
	             	(Library.load_library spec;
	             	if (not (old_current = current_theory())) then 		            
	             	    (map ( fn (_,client,_,_) => client (current_theory())) 	            
	            		(! notification_list);())
	             	else if (not (old_parents = parents "-")) then
	             	    (map ( fn (_,_,client,_) => client (current_theory())) 	            
	            		(! notification_list);())
		   else ()) end;					


	fun test () = 
	    let exception CURRENT_THEORY_CHANGE
		exception NEW_PARENT_ADDED
		exception CURRENT_THEORY_MODE_CHANGE in (
		add_client(mk_client(
			"client1", 
			(fn x => raise CURRENT_THEORY_CHANGE),
			(fn x => raise NEW_PARENT_ADDED),
			(fn x => raise CURRENT_THEORY_MODE_CHANGE)));
		((new_theory "test"; false) handle CURRENT_THEORY_CHANGE => true)
		andalso ((close_theory(); false) handle CURRENT_THEORY_MODE_CHANGE => true)
	   ) end;

end;

(*--------------------------------------------------------------       	*)
(* current theory tcl clients		 				*)
(*        						       		*)
(* For testing:       						       	*)
(* fun tcl x= tty_write x; 						*)
(* 								       	*)
(*--------------------------------------------------------------       	*)

structure TclCurrentTheoryNotification : TclCurrentTheoryNotification_sig = 
struct
	type client = string * string;
	fun mk_client x = (x:client);

	fun add_client (tclclass,tclobj) =
		CurrentTheoryNotification.add_client (
		   (tclclass ^ tclobj),
		   ( fn thr => tcl (tclclass ^ "::current_theory_change_Notify "  ^ tclobj ^ " " ^ thr)),
		   ( fn thr => tcl (tclclass ^ "::current_theory_ancestry_change_Notify "  ^ tclobj ^ " " ^ thr)),
		   ( fn draftmode => tcl (tclclass ^ "::current_theory_mode_change_Notify "  ^ tclobj ^ " " ^ (if (draftmode) then "1" else "0")))
	 	);

	fun remove_client (tclclass,tclobj) =
		CurrentTheoryNotification.remove_client (tclclass ^ tclobj);
end

