;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                             HOL 88 Version 2.0                          ;;;
;;;                                                                         ;;;
;;;   FILE NAME:        f-tcl-format.l                                      ;;;
;;;                                                                         ;;;
;;;   DESCRIPTION:      Modified printing to implement HolRichText	    ;;;
;;;                                                                         ;;;
;;;   USES FILES:       f-franz.l (or f-cl.l), f-macro.l, f-constants.l     ;;;
;;;                                                                         ;;;
;;;                     University of Cambridge                             ;;;
;;;                     Hardware Verification Group                         ;;;
;;;                     Computer Laboratory                                 ;;;
;;;                     New Museums Site                                    ;;;
;;;                     Pembroke Street                                     ;;;
;;;                     Cambridge  CB2 3QG                                  ;;;
;;;                     England                                             ;;;
;;;									    ;;;
;;;	NOTE: PROBABLY NO LONGER WORKS FOR FRANZ LISP			   ;;;
;;;                                                                         ;;;
;;;   COPYRIGHT:        University of Edinburgh                             ;;;
;;;   COPYRIGHT:        University of Cambridge                             ;;;
;;;   COPYRIGHT:        INRIA                                               ;;;
;;;   COPYRIGHT:        Donald Syme                                         ;;;
;;;                                                                         ;;;
;;;   REVISION HISTORY: Created by L. Paulson in unix version 3.1           ;;;
;;;                                                                         ;;;
;;; V4.1 added "inconsistent breaks", record macros, depth limit,           ;;;
;;;     hypenated some names                                                ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(eval-when (compile)
   #+franz (include "lisp/f-franz")
   (include "lisp/f-macro")
   (include "lisp/f-constants")
   (special %max-depth %margin %output-buffer %caught-output %catching-output %tcl-tagged-output))


;;; constant definitions

(eval-when (compile load)
   (defconstant %infinity 999999))        ;large value for default token size


;;; global variables added for HOLRichText implementation

(setq %caught-output "")			; Hack added by DRS
(setq %catching-output nil)			; Hack added by DRS
(setq %tcl-tagged-output nil)			; Hack added by DRS

;;; data structures
;;; a token is one of
;;;    ('string  text)
;;;    ('break   width  offset)
;;;    ('begin   indent  [in]consistent )
;;;    ('end)

(eval-when (compile)
   (defmacro tok-class (tok) `(car ,tok))
   (defmacro get-string-text (tok) `(cadr ,tok))
   (defmacro get-break-width (tok) `(cadr ,tok))
   (defmacro get-break-offset (tok) `(caddr ,tok))
   (defmacro get-block-indent (tok) `(cadr ,tok))
   (defmacro get-block-break (tok) `(caddr ,tok)))


;;; the Scan Stack
;;; each stack element is (left-total . qi)
;;;   where left-total the value of %left-total when element was entered
;;;   and qi is the queue element whose size must later be set 

(eval-when (compile)
   (defmacro make-ss-elem (left qi) `(cons ,left ,qi))
   (defmacro get-left-total (x) `(car ,x))
   (defmacro get-queue-elem (x) `(cdr ,x)))


;;; the Queue
;;; elements (size token len)   

(eval-when (compile)
   (defmacro make-queue-elem (size tt len) `(list ,size ,tt ,len))
   (defmacro get-queue-size (q) `(car ,q))
   (defmacro get-queue-token (q) `(cadr ,q))
   (defmacro get-queue-len (q) `(caddr ,q))
   (defmacro put-queue-size (q size) `(rplaca ,q ,size)))


;;; the Printing Stack, %pstack 
;;;  each element is (break . offset)

(eval-when (compile)
   (defmacro get-print-break (x) `(car ,x))
   (defmacro get-print-indent (x) `(cdr ,x)))


;;; DRS HUGE HACK - in order to implement "thm_to_string" we
;;;  grab all output as it comes out of the pretty printer.
;;;  This will not work with franz lisp I guess (when catching
;;; it shouldn't matter - we will only catch when printing theorems).
(defun flush-output-buffer nil
   ;; Some data types (e.g. streams) cannot be catenated in franz, so
   ;; print out items in buffer separately.
   (cond (%catching-output 
            (setq %caught-output (concatl (cons %caught-output (nreverse %output-buffer)))))
	 (t
	    #+franz (mapc #'llprinc (nreverse %output-buffer))
            #-franz (llprinc (apply #'catenate (nreverse %output-buffer)))
   ))
   (setq %output-buffer nil))


;;; print n blanks
;;; Modified to print blanks as { sp {...} } when catching output
;;; in tcl format.
(defun print-blanks (n)
   (if %tcl-tagged-output (push "{ sp {" %output-buffer))
   (do ((i n (1- i))) ((zerop i)) (push " " %output-buffer))
   (if %tcl-tagged-output (push "} } " %output-buffer))
  )


;;; print a break, indenting a new line
;;; Modified to print newlines as { sp {\N} } when catching output
;;; in tcl format.
(defun break-new-line (tt)
   (setq %space (- (get-print-indent (car %pstack)) (get-break-offset tt)))
   (flush-output-buffer)
   (cond (%tcl-tagged-output 
		(push "{ sp {" %output-buffer)
		(push #\NEWLINE %output-buffer)
		(push "} } " %output-buffer))
         (%catching-output 
		(push #\NEWLINE %output-buffer))
         (t (llterpri)))
   (print-blanks (- %margin %space)))          ; break-new-line

