%<#####################################################################	>%
%<   conv_to_text.ml,v 1.8 1995/04/04 16:38:49 drs1004 Exp	>%
%<    Copyright (C) 1994  Donald Syme				     	>%
%<								     	>%
%<    This program is free software; you can redistribute it and/or modify    >%
%<    it under the terms of the GNU General Public License as published by    >%
%<    the Free Software Foundation; either version 1, or (at your option)     >%
%<    any later version.							     >%
%<									     >%
%<    This program is distributed in the hope that it will be useful,	     >%
%<    but WITHOUT ANY WARRANTY; without even the implied warranty of	     >%
%<    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	     >%
%<    GNU General Public License for more details.			     >%
%<									     >%
%<    You should have received a copy of the GNU General Public License	     >%
%<    along with this program; if not, write to the Free Software	     >%
%<    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     >%
%<									     >%
%<    Contact Details:							     >%
%<	Donald Syme							     >%
%<	The Computer Laboratory						     >%
%<	New Musuems Site						     >%
%<	Pembroke St.							     >%
%<	Cambridge U.K. CB2 3QG						     >%
%<									     >%
%<	email: Donald.Syme@cl.cam.ac.uk					     >%
%<									     >%
%<############################################################################>%

%<----------------------------------------------------------------------->%
%< thm_to_hol_rich_text_via_file: thm -> string -> string		>%
%< term_to_hol_rich_text_via_file: thm -> string -> string		>%
%< goal_to_hol_rich_text_via_file: thm -> string -> string		>%
%<									>%
%< thm_to_plain_text_via_file: thm -> string -> string			>%
%< term_to_plain_text_via_file: thm -> string -> string			>%
%< goal_to_plain_text_via_file: thm -> string -> string			>%
%<									>%
%< Pretty prints various things into a file in a tagged format suitable	>%
%< for reading by Tcl, or in a plain HOL pretty print format.		>%
%<									>%
%< Returns the name of the temporary file created under /tmp		>%
%< Desperately needs a better way of generating temporary file names     >%
%<----------------------------------------------------------------------->%


letrec write_to_file s tmpfilename =
	    	let tmpfile = openw tmpfilename in
	    	write (tmpfile,s);
	    	close(tmpfile);
	    	tmpfilename;;

letrec arb_goal_to_text (term_to_text,gl_asm_sep,asm_begin,asm_end) (numberAssums,firstOnTop) (asms,tm) = 
	let asmconv i asm = 
 	    [(if (numberAssums) then (string_of_int i) else ``);
	     ` `; asm_begin; (term_to_text asm); asm_end] in
	letrec asmtext i asms = 
		if (null asms) then []
		else 
		    let text = asmconv i (hd asms) in
		    if (firstOnTop) then 
		        text@(asmtext (i+1) (tl asms))
		    else
		        (asmtext (i+1) (tl asms))@text in
	let glstring = [(term_to_text tm); gl_asm_sep] in
	concatl (glstring@(asmtext 1 asms));;
	
let term_to_hol_rich_text_via_file = write_to_file o term_to_hol_rich_text;;
let thm_to_hol_rich_text_via_file = write_to_file o thm_to_hol_rich_text;;
let goal_to_hol_rich_text_via_file args gl tmpfilename =
	write_to_file (arb_goal_to_text (term_to_hol_rich_text,` { tm {\L\L} }`,` { asm {[ } } `,` { asm { ]\L} } `) args gl) tmpfilename;;

let term_to_plain_text_via_file = write_to_file o term_to_plain_text;;
let thm_to_plain_text_via_file = write_to_file o thm_to_plain_text;;
let goal_to_plain_text_via_file args gl tmpfilename = 
	write_to_file (arb_goal_to_text (term_to_plain_text,`\L\L`,`[ `,` ]\L`) args gl) tmpfilename;;



