#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




option add *Shell.inputcolor blue widgetDefault
option add *Shell.outputcolor black widgetDefault
option add *Shell.command "uplevel #0" widgetDefault
option add *Shell.initialtext "" widgetDefault
option add *Shell.prompt "%" widgetDefault

proc shell { w args} {
        global TkHolShell_flags
        global vals
        set passon_args ""
        for {set i 0} {$i<[llength $args]} {incr i} {
            case [lindex $args $i]  -prompt {
                incr i
                set prompt [lindex $args $i]
            } -inputcolor {
                incr i
                set inputcolor [lindex $args $i]
            } -outputcolor {
                incr i
                set outputcolor [lindex $args $i]
            } -command {
                incr i
                set command [lindex $args $i]
            } -initialtext {
                incr i
                set initialtext [lindex $args $i]
            } default {
                lappend passon_args [lindex $args $i]
                incr i
                lappend passon_args [lindex $args $i]
            }
        }
        frame $w -class Shell
        eval [list text $w.text -relief sunken -borderwidth 2] $passon_args
        pack $w.text -expand yes -fill both

        if ![info exists inputcolor] { set inputcolor [option get $w inputcolor InputColor] } 
        if ![info exists outputcolor] { set outputcolor [option get $w outputcolor OutputColor] }
        if ![info exists command] { set command [option get $w command Command] }
        if ![info exists initialtext] { set initialtext [option get $w initialtext InitialText] }
        if ![info exists prompt] { set prompt [option get $w prompt InitialText] }

        set vals($w,prompt) $prompt
        $w.text tag configure output -foreground $outputcolor
        $w.text tag configure input -foreground $inputcolor
        
        shell::shell_bind $w

#       puts "bind ShellText = [bind ShellText]"
#       puts "bindtags $w.text = [bindtags $w.text]"
#       puts "bind $w.text <Key-Return> = [bind $w.text <Key-Return>]"

        shell::output $w $initialtext
        shell::output $w $prompt
        shell::prepare_for_input $w
        $w.text yview 0.0

        set vals($w,command) $command
        return $w
}


proc shell::execute { w } {
        global vals
        set code [shell::latest_command $w] 
        shell::fix_latest_command $w
        shell::output $w \n
        update idletasks
        catch {eval $vals($w,command) [list $code]} result
        shell::output $w $result
        if {$vals($w,prompt) != ""} { shell::output $w "\n$vals($w,prompt)" }
        shell::prepare_for_input $w
}


proc shell::output { w text } {
        $w.text insert end $text output
        $w.text yview -pickplace insert
}
        
proc shell::prepare_for_input { w } {
        $w.text insert end " " input
        $w.text mark set insert end
        $w.text yview -pickplace insert
}


proc shell::latest_command { w } {
        global vals
        return [$w.text get "output.last + 1 c" end]
}


proc shell::fix_latest_command { w } {
        global vals
#       puts "text = [$w.text get "output.last + 1 c" end]"
        if [info exists vals($w,history_index)] {
            set endindex [expr [llength $vals($w,history)]-1]
            set text [string trim [$w.text get "output.last + 1 c" end]]
            set vals($w,history) [lreplace $vals($w,history) $endindex $endindex $text]
        } else {
            lappend vals($w,history) [$w.text get "output.last + 1 c" end]
        }
        if {[llength $vals($w,history)]>100} {
            set vals($w,history) [lrange $vals($w,history) 1 end]
        }
        catch {unset vals($w,history_index)}
}


######################################################################
###  TEXT MOVEMENT COMMANDS
######################################################################

proc shell::replace_command { w text } {
        $w.text delete "output.last + 1 c" end
        $w.text insert end $text input
        $w.text mark set insert end
        $w.text yview -pickplace insert
}


#We use the existence of vals($w,history_index) to determine if we are on
# the "last" (current) history line.  Maybe there's a better wayu to
# do this??
proc shell::prev_command { w } {
    global vals
    if ![info exists vals($w,history_index)] {
        lappend vals($w,history) [$w.text get "output.last + 1 c" end]
        set vals($w,history_index) [expr [llength $vals($w,history)]-1]
    }
#       puts "history = $vals($w,history)"
#    puts "historyi_index = $vals($w,history_index)"
    if {$vals($w,history_index) > 0} {
        incr vals($w,history_index) -1
        shell::replace_command $w [lindex $vals($w,history) $vals($w,history_index)]
    }
    if {$vals($w,history_index) == [llength $vals($w,history)]-1} {
        unset vals($w,history_index)
        set endindex [expr [llength $vals($w,history)]-1]
        set vals($w,history) [lreplace $vals($w,history) $endindex $endindex]
    }
}


proc shell::next_command { w } {
    global vals
    if ![info exists vals($w,history_index)] {
        return
    }
#    puts "history = $vals($w,history)"
#    puts "history_index = $vals($w,history_index)"
    if {$vals($w,history_index) < [expr [llength $vals($w,history)]-1]} {
        incr vals($w,history_index) 1
        shell::replace_command $w [lindex $vals($w,history) $vals($w,history_index)]
    }
    if {$vals($w,history_index) == [llength $vals($w,history)]-1} {
        unset vals($w,history_index)
        set endindex [expr [llength $vals($w,history)]-1]
        set vals($w,history) [lreplace $vals($w,history) $endindex $endindex]
    }
}

#--------------------------------------------------------------------
# 
#-------------------------------------------------------------------


proc shell::check { command textw } {
    uplevel #0 $command 
    if {[$textw compare insert <= output.last]} { 
        $textw mark set insert "output.last + 1 c "
    }
}

#---------------------------------------------------------------------
# ROUTINES TO SET UP TEXT BINDINGS
#---------------------------------------------------------------------

# set up Shell bindings.



proc tkShellInsert {w s} {
    if {($s == "") || ([$w cget -state] == "disabled")} {
        return
    }
    catch {
        $w tag remove sel 1.0 end
    }
    $w insert insert $s input
    $w see insert
}


foreach event [bind Text] {
    set class_binding [bind Text $event]
    regsub tkTextInsert $class_binding tkShellInsert new_binding
    bind ShellText $event "shell::check \{$new_binding\} %W"
}


proc shell::shell_bind { w } {
        global gui_flags
        global shell_flags
        global vals

        # supplement class bindings by checking if the insertion
        # cursor is out of bounds after executing them

        bindtags $w.text [list $w.text ShellText [winfo toplevel $w] all]
        bind $w.text <Up> "shell::prev_command $w ; break"
        bind $w.text <Down> "shell::next_command $w ; break"
        bind $w.text <Return> "shell::execute $w ; break"

}

