#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




#----------------------------------------------------------------------------
# TheoremWidgets::ProcessArgs
#
#       -norichtext     turn rich text output off.  Automatically off
#                       for hol90.
#
#----------------------------------------------------------------------------

proc TheoremWidgets::ProcessArgs { argc argv } {
        global TheoremWidgets_flags

   if {[llength [info commands Preferences_Add]]==1} {

    Preferences_Add "Term, Type and Theorem Display" \
"Preferences related to the formatting of HOL terms may be \
specified here.  At present the list is overly complex - a simpler \
method of specifying font sizes and colors will be implemented \
some time soon. 

Interface maps produce special symbols and fonts such as those for set \
and arithmetic operations. Changing these values will \
only take effect if you save the options and restart TkHolWorkbench, \
or if you call the Tcl procedure
        TheoremWidgets::installInterfaceMap <interface map name> \$TheoremWidgets_flags(interface_map,<interface map name>)
from a Tcl window (see the \"Packages\" menu)." [list \
        [list TheoremWidgets_flags(pasteWithTypes) pasteWithTypes BOOL 0 "Paste With Types"  "If this is selected, types will be annotated when pasting selected term by default."] \
        [list TheoremWidgets_flags(showAssums) showAssums BOOL 0 "Theorems: Show Assumptions"  "If this is true then assumptions to theorems will be printed by default."] \
        [list TheoremWidgets_flags(showRestrictions) showRestrictions BOOL 1 "Terms: Show Restrictions"  "If this is true then restricted quantifications will be printed."] \
        [list TheoremWidgets_flags(showTypes) showTypes BOOL 0 "Terms: Show Types"  "If this is true then types will be printed by default."] \
        [list TheoremWidgets_flags(interfaceMaps) interfaceMaps STRING [list BaseLogicTk SetsTk RealsTk] "TheoremWidgets Interface Maps" "The interface maps to use when displaying Richtext. These are specified below. "] \
        [list TheoremWidgets_flags(mapsOnByDefault) interfaceMapping BOOL 1 "Use Interface Maps by Default" "Whether TkHolWorkbench should use interface maps by default."] \
        [list TheoremWidgets_flags(numberAssums) numberAssums BOOL 1 "Goals: Number Assumptions"  "If this is true then the assumptions list of goals will be numbered." ] \
        [list TheoremWidgets_flags(firstAssumOnTop) firstAssumOnTop BOOL 1 "Goals: First assumption on top"  "This specifies whether the first assumption should be displayed at the top or the bottom of the assumption list."] \
        [list TheoremWidgets_flags(goalLine) goalLine STRING "" "Goals: Seperator"  "Seperator between the goal and assumptions." ] \
        [list TheoremWidgets_flags(thmNameLook) thmNameLook LOOK Helvetica-Medium-R-Normal-small|*-*-*-*-Black-*-1-*-*  "Theorem Name Look" "The style used to display theorem names."] \
        [list TheoremWidgets_flags(thmKindLook) thmKindLook LOOK Helvetica-Medium-O-Normal-small|*-*-*-*-Black-*-*-*-*  "Theorem Kind Look" "The style used to display theorem kinds."] \
      ]

    Preferences_Add "Interface Maps" \
"Install and alter interface maps.  A proper interface to create, modify and save interface maps will be developed in due course." \
      [list \
        [list TheoremWidgets_flags(interface_map,BaseLogicTk) BaseLogicTk INTERFACE_MAP [list \
            [list [list COMB CONST]     !               [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  \"      \"]]] \
            [list [list COMB CONST]     ?               [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  \$      \$]]] \
            [list [list COMB CONST]     ~               [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  ~       ~]]] \
            [list [list COMB CONST]     /\\             [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  {\217}  "\x0d9"]]] \
            [list [list COMB CONST]     \\/             [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  {\218}  "\x0da"]]] \
            [list [list COMB CONST]     ==>             [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  {\222}  "\x0de"]]] \
            [list [list COMB CONST]     <==             [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  {\220}  "\x0dc"]]] \
            [list [list COMB CONST]     ->              [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  {\174}  "\x0ae"]]] \
            [list [list COMB CONST]     >=              [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  {\179}  "\x0b3"]]] \
            [list [list COMB CONST]     <=              [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  {\163}  "\x0a3"]]] \
            [list [list COMB CONST]     *               [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  {\180}  "\x0b4"]]] \
            [list [list ABS]            \\              [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  l       l]]] \
            [list [list CONST VAR]      (               {}] \
            [list [list CONST VAR]      )               {}] \
            [list [list CONST VAR]      :               {}] \
            [list [list TYPE]           'a              [list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-*-103-*         {a}     {a}]]] \
            [list [list TYPE]           'a1             [list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-*-103-*         {a1}    {a1}]]] \
            [list [list TYPE]           'a2             [list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-*-103-*         {a2}    {a2}]]] \
            [list [list TYPE]           'b              [list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-*-103-*         {b}     {b}]]] \
            [list [list TYPE]           'c              [list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-*-103-*         {c}     {c}]]] \
            [list [list TYPE]           'd              [list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-*-103-*         {d}     {d}]]] \
            [list [list TYPE]           'e              [list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-*-103-*         {e}     {e}]]] \
            [list [list TYPE]           'f              [list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-*-103-*         {f}     {f}]]] \
            [list [list TYPE]           ->              [list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-*-103-*         {\174} "\x0ae"]]] \
            [list [list TYPE]           {}              Roman-Medium-I-Normal-tiny|*-*-*-*-Black-*-*-103-*] \
 \
            [list [list CONST]          {}              Roman-Medium-R-Normal-Normal|*-*-*-*-Black-*-*-*-*] \
            [list [list VAR]            {}              Roman-Medium-I-Normal-Normal|*-*-*-*-Blue-*-*-*-*] \
            [list [list default]        {}              Roman-Medium-R-Normal-Normal|*-*-*-*-Black-*-*-*-*] \
        ] \
        "BasicLogicTk Interface Map" \
"The interface map used for producing nifty looking symbols in Tk \
for the constructs in the HOL basic logic, and the arithmetic and lists \
libraries as well."] \
        \
        [list TheoremWidgets_flags(interface_map,SetsTk) SetsTk INTERFACE_MAP [list \
            [list [list COMB CONST]     IN              [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  {\206}  "\x0ce"]]] \
            [list [list COMB CONST]     SUBSET          [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  {\205}  "\x0cd"]]] \
            [list [list COMB CONST]     PSUBSET         [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  {\204}  "\x0cc"]]] \
            [list [list COMB CONST]     INTER           [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  {\199}  "\x0c7"]]] \
            [list [list COMB CONST]     UNION           [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  {\200}  "\x0c8"]]] \
            [list [list CONST]          \{\}            [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  {\198}  "\x0c6"]]] \
            [list [list SET]            \\              [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  |       |]]] \
            [list [list SET]            setlambda       [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  |       |]]] \
        ] \
        "SetsTk Interface Map" \
"The interface map used for producing nifty looking symbols in Tk \
for set theory constructs as found in the sets, finite_sets and \
pred_sets libraries."] \
        \
        [list TheoremWidgets_flags(interface_map,RealsTk) RealsTk INTERFACE_MAP [list \
            [list [list COMB CONST]     |<=|    [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-black-*-*-*-*  {\163}  "\x0a3"]]] \
            [list [list COMB CONST]     |<|     [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-black-*-*-*-*  <       <]]] \
            [list [list COMB CONST]     |>|     [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-black-*-*-*-*  >       >]]] \
            [list [list COMB CONST]     |>=|    [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-black-*-*-*-*  {\179}  "\x0b3"]]] \
            [list [list COMB CONST]     --      [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-black-*-*-*-*  -       -]]] \
            [list [list COMB CONST]     |-|     [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-black-*-*-*-*  -       -]]] \
            [list [list COMB CONST]     |+|     [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-black-*-*-*-*  +       +]]] \
            [list [list COMB CONST]     |*|     [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-black-*-*-*-*  {\180}  "\x0b4"]]] \
            [list [list COMB CONST]     /               [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-black-*-*-*-*  {\184}  "\x0b8"]]] \
            [list [list COMB CONST]     &       [list [list Roman-Medium-R-Normal-Normal|*-*-*-*-Black-*-*-*-*  &       &]]] \
            [list [list CONST]          pi              [list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-*  p       p]]] \
        ] \
        "RealsTk Interface Map" \
"The interface map used for producing nifty looking symbols in Tk \
for real number constructs like those found in \
the reals library."] \
        \
      ]


   }

        set TheoremWidgets_flags(goalLine) ""

        for {set arg 0} {$arg < $argc} {incr arg} {
            if {[lindex $argv $arg]=="-norichtext"} {
                set TheoremWidgets_flags(richtext) 0
            }
        }
}


proc TheoremWidgets::InitialisePackage { } {
        global TheoremWidgets_flags
        global gui_flags
        set TheoremWidgets_flags(structuredtext_loaded) 0
        
        global RichText_flags
        if ![ML -type bool "op_mem lib_eq (find_library [ml_string holpp_to_tcl]) (loaded_libraries())"] {
            set RichText_flags(structuredtextOnByDefault) 0
        }
}
