(*====================================================================
 *
 * structure HolTermPaths
 *                                                                    
 * use "hol90_termpaths/src/termpaths.sig";
 * use "hol90_termpaths/src/termpaths.sml";
 *====================================================================*)

structure HolTermPaths: HolTermPaths_sig =
struct

   datatype termbranch = 
   	RATOR | 
   	RAND | 
   	BODY;

   type termpath = termbranch list;
       
   fun lookup_branch RATOR tm = (rator tm)
     | lookup_branch RAND tm = (rand tm)
     | lookup_branch BODY tm = (body tm);
     
   fun lookup_path tp tm = itlist lookup_branch tp tm;

end;



