(****************************************************************************)
(*                                                                          *)
(*                  Copyright 1994 University of Cambridge                  *)
(*                                                                          *)
(*                           All rights reserved.                           *)
(*                                                                          *)
(****************************************************************************)

(****************************************************************************)
(* FILE          : ppboxes_hide_label.ml                                    *)
(* DESCRIPTION   : Transforming a labelled ppbox structure to an unlabelled *)
(*                 one.                                                     *)
(*                                                                          *)
(* AUTHOR        : R.J.Boulton                                              *)
(* DATE          : 14th June 1994                                           *)
(*                                                                          *)
(* LAST MODIFIED : R.J.Boulton                                              *)
(* DATE          : 30th November 1994                                       *)
(****************************************************************************)

functor HideLabelPPBoxesFun (LabelPPBoxes : LABEL_PPBOXES) : PPBOXES =
struct

open LabelPPBoxes; (* Allows datatype ppindent to be visible *)

type ppbox = unit LabelPPBoxes.ppbox;

val pp_empty_box = LabelPPBoxes.pp_empty_box
and pp_string_box = LabelPPBoxes.pp_string_box ()
and pp_h_box = LabelPPBoxes.pp_h_box ()
and pp_v_box = LabelPPBoxes.pp_v_box ()
and pp_hv_box = LabelPPBoxes.pp_hv_box ()
and pp_hov_box = LabelPPBoxes.pp_hov_box ()
and pp_h_sepbox = LabelPPBoxes.pp_h_sepbox ()
and pp_v_sepbox = LabelPPBoxes.pp_v_sepbox ()
and pp_hv_sepbox = LabelPPBoxes.pp_hv_sepbox ()
and pp_hov_sepbox = LabelPPBoxes.pp_hov_sepbox ()
and write_ppbox = LabelPPBoxes.write_ppbox
and ppbox_to_string = LabelPPBoxes.ppbox_to_string;

end; (* HideLabelPPBoxesFun *)


functor PPBoxesFun (Scale : sig val char_size : int end) =
   HideLabelPPBoxesFun (LabelPPBoxesFun (Scale));
