(*====================================================================
 *
 * structure HolTermPathTactics
 *                                                                    
 *====================================================================*)

structure HolTermPathTactics: HolTermPathTactics_sig =
struct

   open HolTermPaths;

   exception PATH_MISMATCH

  (* These are redefined because of the poor quality of hol90 RAND_CONV/RATOR_CONV/ABS_CONV
     error messages.  "PATH_MISMATCH" isn't much better though... *)

   fun RATOR_CONV' conv tm =
   let val {Rator,Rand} = dest_comb tm handle (HOL_ERR _) 
                          => raise PATH_MISMATCH
   in AP_THM (conv Rator) Rand 
   end

   fun RAND_CONV' conv tm =
   let val {Rator,Rand} = dest_comb tm handle (HOL_ERR _) => raise PATH_MISMATCH
   in AP_TERM Rator (conv Rand)
   end

   fun ABS_CONV' conv tm =
   let val {Bvar,Body} = dest_abs tm handle (HOL_ERR _) => raise PATH_MISMATCH
   in ABS Bvar (conv Body)
   end;

   fun conv_for_branch RATOR = RATOR_CONV'
     | conv_for_branch RAND = RAND_CONV'
     | conv_for_branch BODY = ABS_CONV';
   val PATH_CONV = itlist conv_for_branch;
   fun PATH_CONV_TAC pl cv = CONV_TAC (PATH_CONV pl cv);
   fun PATH_REWRITE_TAC pl = (PATH_CONV_TAC pl) o REWRITE_CONV
   fun PURE_PATH_REWRITE_TAC pl = (PATH_CONV_TAC pl) o PURE_REWRITE_CONV
   fun ONCE_PATH_REWRITE_TAC pl = (PATH_CONV_TAC pl) o ONCE_REWRITE_CONV
   fun PURE_ONCE_PATH_REWRITE_TAC pl = (PATH_CONV_TAC pl) o PURE_ONCE_REWRITE_CONV

   fun GEN_ASM_REWRITE_TAC f pl thl =   
      ASSUM_LIST (fn asl => f pl (asl @ thl))
   val PURE_PATH_ASM_REWRITE_TAC = GEN_ASM_REWRITE_TAC PURE_PATH_REWRITE_TAC
   and PATH_ASM_REWRITE_TAC = GEN_ASM_REWRITE_TAC PATH_REWRITE_TAC
   and PURE_ONCE_PATH_ASM_REWRITE_TAC = GEN_ASM_REWRITE_TAC PURE_ONCE_PATH_REWRITE_TAC
   and ONCE_PATH_ASM_REWRITE_TAC = GEN_ASM_REWRITE_TAC ONCE_PATH_REWRITE_TAC

end;


