#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




#----------------------------------------------------------------------------
#
# ProcessArgs
#
#----------------------------------------------------------------------------

proc TkTheoryViewer::ProcessArgs { argc argv } {
        global TkTheoryViewer_flags
        global TheoryTree_flags
        global gui_flags
        set TkTheoryViewer_flags(proof_packages) ""
        set TkTheoryViewer_flags(type_packages) ""
        set TkTheoryViewer_flags(definition_packages) ""
        set TkTheoryViewer_flags(axiom_packages) ""
        set TkTheoryViewer_flags(search_packages) ""
        set TkTheoryViewer_flags(other_packages) ""

        if {[llength [info commands Preferences_Add]]==1} {
            Preferences_Add "Theory Hierarchy Display" "Preferences related to the display of the theory hierarchy are set here." \
                [list \
                    [list TheoryTree_flags(font) theoryTreeFont FONT "-Adobe-Helvetica-Medium-R-Normal--*-100-*" "Theory Tree Font" "The font in which to display theory names within the theory tree."]  \
                    [list TheoryTree_flags(theoryTreeAnchor) theoryTreeAnchor [list CHOICE s se w nw n ne e sw] s "Theory Tree Anchor" "This determines the manner in which the theory tree is drawn.  The value indicates a position on the compass from which the tree is drawn.  For instance \"s\" indicates that the tree should be drawn with the current theory at the bottom."] \
                    [list TheoryTree_flags(theoryTreeInitialExpand) theoryTreeInitialExpand NUM 2 "Initial Expansion Depth" "The depth to which the theory tree is initially expanded."] \
                    [list TheoryTree_flags(theoriesToFlatten) theoriesToFlatten LIST [list HOL BASIC_HOL HolPlus] "Theories at which to Flatten" "This determines the theories at which the theory tree will be \"flattened\".  This is done by showing all the ancestors of these theories as parents, instead of just showing the immediate parents.  This is useful for collector theories such as HOL and BASIC_HOL, and possibly for some of your own theories as well."] \
                    [list TheoryTree_flags(theoriesToIgnore) theoriesToIgnore LIST  [list HOL BASIC_HOL HolPlus min] "Theories to Ignore" "These theories are ignored unless they are the sole parent of a theory.  This is useful for theories which are only parents of theories due to their status as the initial theory of a HOL session.  Theories such as HOL and BASIC_HOL fall into this category."] \
                    [list TheoryTree_flags(theoriesToPrune) theoriesToPrune LIST [list HOL HolPlus] "Theories to Prune" "The initial expansion of the tree is pruned at these theories.  This can be used to prevent blowout of the initial display of the theory tree."] \
             ]

            Preferences_Add "Start Up" "Preferences related to the state $gui_flags(title) starts in." \
                [list \
                    [list TkTheoryViewer_flags(starton) starton BOOL 0 "Create a TkTheoryViewer at startup" "If this is set, a TkTheoryViewer window will be created when $gui_flags(title) is executed"] \
             ]
        }

        for {set arg 0} {$arg < $argc} {incr arg} {
            switch -regexp -- [lindex $argv $arg] -(i|interface|on) {
                set TkTheoryViewer_flags(starton) 1
            } -theoryTreeInitialExpand {
                incr arg
                set TheoryTree_flags(theoryTreeInitialExpand) [lindex $argv $arg] 
            } -theoryTreeAnchor {
                incr arg
                set TheoryTree_flags(theoryTreeAnchor) [lindex $argv $arg] 
            } -proofpackage {
                incr arg
                lappend TkTheoryViewer_flags(proof_packages) [lindex $argv $arg] 
            } -definitionpackage {
                incr arg
                lappend TkTheoryViewer_flags(definition_packages) [lindex $argv $arg] 
            } -searchpackage {
                incr arg
                lappend TkTheoryViewer_flags(search_packages) [lindex $argv $arg] 
            } -axiompackage {
                incr arg
                lappend TkTheoryViewer_flags(axiom_packages) [lindex $argv $arg] 
            } -otherpackage {
                incr arg
                lappend TkTheoryViewer_flags(other_packages) [lindex $argv $arg] 
            }
        }
}
        
proc TkTheoryViewer::InitialisePackage { args } {
        global TkTheoryViewer_flags
        set TkTheoryViewer_flags(loaded) 0
        if $TkTheoryViewer_flags(starton) {
            newwin TkTheoryViewer
        }
}


