#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




option add *LoadLibraryBox.header "" widgetDefault
option add *LoadLibraryBox.resultsvariable results widgetDefault

proc LoadLibraryBox { w args } {
        global vals 
        global gui_flags


        for {set i 0} {$i<[llength $args]} {incr i} {
            switch -- [lindex $args $i] -header {
                incr i
                set header [lindex $args $i]
            } -resultsvariable {
                incr i
                set vals($w,resultsvariable) [lindex $args $i]
            } default {
                error "unrecognized arg [lindex $args $i]"
            }
        }
        frame $w -class LoadLibraryBox
        if ![info exists header] { set header [option get $w header Header] }
        if ![info exists resultsvariable] { set resultsvariable [option get $w resultsvariable ResultsVariable] }

        pack [label $w.header \
                -text $header \
                -font $gui_flags(font,labels) \
                -anchor w] \
            -side top -padx 10 -fill x
            

        pack [frame $w.options] -side top -pady 10
        pack [frame $w.options.buttons] \
            -side right -pady 10
            
        pack [entry $w.options.lib \
                -relief sunken \
                -borderwidth 2 \
                -font $gui_flags(font,textentry) \
                -textvariable vals($w,entry)] \
            -side bottom -fill x -padx 10
        
        pack [scrollable selectlistbox $w.options.list \
                -width 20 \
                -height 10 \
                -relief sunken \
                -borderwidth 2 \
                -selectmode browse \
                -selectionvar vals($w,selection)] \
            -side left -padx 10
        trace variable vals($w,selection) w [list trace_ignore [list LoadLibraryBox::select $w]]
        bind $w.options.list.b <Double-Button-1> \
                [list LoadLibraryBox::ok_pressed $w]
        pack [fontcheck button $w.options.buttons.find_lib \
                -width 13 \
                -text "Find Library" \
                -command "LoadLibraryBox::find_library $w"] \
            -side top
        pack [fontcheck button $w.options.buttons.add_path \
                -width 13 \
                -text "Add Path..." \
                -command "LoadLibraryBox::add_path $w"] \
            -side top
            
            
        pack [frame $w.controls] -side bottom -pady 10
        pack [fontcheck button $w.controls.ok \
                -width 6 \
                -text Ok \
                -command "LoadLibraryBox::ok_pressed $w"] \
            -side left \
            -padx 10
        pack [fontcheck button $w.controls.cancel \
                -width 6 \
                -text Cancel \
                -command "set $vals($w,resultsvariable) Cancel"] \
            -side left \
            -padx 10
            
        LoadLibraryBox::refill_list $w
            
        wm protocol [winfo toplevel $w] WM_DELETE_WINDOW "set $vals($w,resultsvariable) Cancel"
        button_setDefault $w.controls.ok
        focus_goToFirst $w
        bind $w <Destroy> "unset_vals_for_widget $w"

}



proc LoadLibraryBox::ok_pressed { w } {
        global vals
        set libname [$w.options.lib get]
        upvar #0 $vals($w,resultsvariable) var
        set var [list Ok $libname]
}

proc LoadLibraryBox::find_library { w } {
        global vals
        global busy
        incr busy
        set libname [$w.options.lib get]
        if [catch {ML -check 1 -type any "find_library [ml_string $libname]"} err] {
            errormessage $w.err $err; incr busy -1; return
        }
        LoadLibraryBox::refill_list $w
        incr busy -1
}


proc LoadLibraryBox::add_path { w } {
        global env
        set file [selectfile -dirvariable pwd -pattern *.[hol_thryext] \
                -message "Select a directory to add, then press OK:" \
                -dironly 1 \
                -action "Add Path"]
        if {$file!=""} {
            ML -toplevel 1 "Globals.library_path := \n([ml_string $file/] \n:: (!Globals.library_path))"
        }
}

proc LoadLibraryBox::refill_list { w } {
        global vals
        set libname [$w.options.lib get]
        if [hol90] {
            set known_libs [ML -type stringlist "map (#name o dest_library) (known_libraries ())"]
            set loaded_libs [ML -type stringlist "map (#name o dest_library) (loaded_libraries ())"]
        }
        $w.options.list.b delete 0 end
        set libs_to_show ""
        foreach lib $known_libs {
                if {[lsearch -exact $loaded_libs $lib]==-1} {
                    lappend libs_to_show $lib
                } 
        }
        set libs_to_show [lsort $libs_to_show]
        foreach lib $known_libs {
                if {[lsearch -exact $loaded_libs $lib]!=-1} {
                    lappend libs_to_show "$lib (already loaded)"
                } 
        }
        if {[llength $libs_to_show]!=0} {
            eval [list $w.options.list.b insert end] $libs_to_show
        }
}


proc LoadLibraryBox::select { w } {
        global vals
        upvar #0 vals($w,entry) entryvar
        set entryvar [$w.options.list.b get [$w.options.list.b cursel]]
}


