#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------





# for autoloading...
proc specifyfixities { } { }

composite_define [list SpecifyFixities Colors] {
        {-header header Header "" composite_configPrivateNop}
        {-resultsvariable resultsVariable ResultsVariable results composite_configPrivateNop}
        {-constructors constructors Constructors "" composite_configPrivateNop}
} SpecifyFixities::initProc

composite_configFlag SpecifyFixities header {w option value} {
        $w.options.header config -text $value
        return private
}


proc SpecifyFixities::initProc { w args } {
        global gui_flags

        pack [frame $w.controls] -side top
        pack [fontcheck button $w.controls.ok \
                -width 6 \
                -text Ok \
                -command "$w ok"] \
            -side left \
            -padx 10
        pack [fontcheck  button $w.controls.cancel \
                -width 6 \
                -text Cancel \
                -command "$w cancel"] \
            -side left \
            -padx 10

        pack [frame $w.options] -side top
        pack [label $w.options.header] \
            -side top -padx 10

        return $w
}



composite_subcommand SpecifyFixities fixityselected { w i fixity } {
        if {$fixity=="Infix"} {
            $w.options.c$i.precname config -foreground black
            $w.options.c$i.precedence config -state normal
            focus_goTo $w.options.c$i.precedence
        } else {
            $w.options.c$i.precname config -foreground grey80
            $w.options.c$i.precedence config -state disabled
        }
}               

composite_subcommand SpecifyFixities ok { w } {
        upvar #0 config$w config
        set result Ok
        set i 0
        foreach constructor $config(constructors) {
            set fixity [$w.options.c$i.fixity get]
            switch -- $fixity {
                Infix {
                    lappend result "Infix [$w.options.c$i.precedence get]"
                }
                default {
                    lappend result $fixity
                }
            }
            incr i
        }
        upvar #0 $config(resultsVariable) var
        set var $result
}


composite_subcommand SpecifyFixities cancel { w } {
        upvar #0 config$w config
        upvar #0 $config(resultsVariable) var
        set var Cancel
}



composite_configFlag SpecifyFixities constructors {w option value} {
        global gui_flags
        foreach win [winfo children $w.options] {
            if {$win != "$w.options.header"} { destroy $win }
        }
        set i 0
        foreach constructor $value {
            pack [frame $w.options.c$i] -side top -pady 5 -padx 10 -fill x -expand yes
#           pack [frame $w.options.p$i] -side top -pady 5 -padx 10

            pack [fontcheck label $w.options.c$i.name  \
                -text "Fixity for $constructor:" \
                -anchor e] \
            -side left -expand yes -fill x

            pack [fontcheck combobox $w.options.c$i.fixity \
                -type history \
                -listboxheight 3 \
                -borderwidth 2 \
                -command "$w fixityselected $i" \
                -entryfont $gui_flags(font,textentry) \
                -listboxfont $gui_flags(font,listboxes)] \
            -side left
            $w.options.c$i.fixity addhistory Binder
            $w.options.c$i.fixity addhistory Infix
            $w.options.c$i.fixity addhistory Prefix
            $w.options.c$i.fixity pick Prefix

            pack [fontcheck label $w.options.c$i.precname \
                -font $gui_flags(font,labels) \
                -text "Precedence:" \
                -foreground grey80] \
            -side left
            pack [fontcheck entry $w.options.c$i.precedence \
                -font $gui_flags(font,textentry) \
                -relief sunken \
                -width 6] -fill x -side right
#           bind $w.options.c$i.precedence <ButtonRelease-1> "$w.options.c$i.fixity pick Infix"

            incr i

        }
        return private
}

