(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)




(***************************************************************************
 * use "/homes/drs1004/projects/tkhol/smlpp/src/sml.pp.support.sml";
 * use "/homes/drs1004/projects/tkhol/smlpp/pp/sml.pp.sml";          
 * SMLDestructors.DNil (parse_exp "[]");;
 * SMLDestructors.DCons (parse_exp "a::b");;
 * SMLDestructors.DList (parse_exp "[1,2]");;
 * SMLDestructors.DFragList (parse_exp "`123`");
 * SMLDestructors.DFragList (parse_exp "``");
 * SMLDestructors.DFragList (parse_exp "`123 ^(1) ^(2)`");
 ****************************************************************************)

structure SMLDestructors = struct 
local
   open System;
in
   fun unMarkExp (Ast.MarkExp (x,_,_)) = x 
     | unMarkExp x = x
   fun unMarkPat (Ast.MarkPat (x,_,_)) = x
     | unMarkPat x = x
   fun unMarkMarkStr (Ast.MarkStr (x,_,_)) = x
     | unMarkMarkStr x = x
   fun unMarkFct (Ast.MarkFct (x,_,_)) = x
     | unMarkFct x = x
   fun unMarkSig (Ast.MarkSig (x,_,_)) = x
     | unMarkSig x = x
   fun unMarkSpec (Ast.MarkSpec (x,_,_)) = x
     | unMarkSpec x = x
   fun unMarkDec (Ast.MarkDec (x,_,_)) = x
     | unMarkDec x = x
   fun unMarkVb (Ast.MarkVb (x,_,_)) = x
     | unMarkVb x = x
   fun unMarkRvb (Ast.MarkRvb (x,_,_)) = x
     | unMarkRvb x = x
   fun unMarkFb (Ast.MarkFb (x,_,_)) = x
     | unMarkFb x = x
   fun unMarkTb (Ast.MarkTb (x,_,_)) = x
     | unMarkTb x = x
   fun unMarkDb (Ast.MarkDb (x,_,_)) = x
     | unMarkDb x = x
   fun unMarkEb (Ast.MarkEb (x,_,_)) = x
     | unMarkEb x = x
   fun unMarkStrb (Ast.MarkStrb (x,_,_)) = x
     | unMarkStrb x = x
   fun unMarkFctb (Ast.MarkFctb (x,_,_)) = x
     | unMarkFctb x = x
   fun unMarkSigb (Ast.MarkSigb (x,_,_)) = x
     | unMarkSigb x = x
   fun unMarkFsigb (Ast.MarkFsigb (x,_,_)) = x
     | unMarkFsigb x = x
   fun unMarkTyv (Ast.MarkTyv (x,_,_)) = x
     | unMarkTyv x = x
   fun unMarkTy (Ast.MarkTy (x,_,_)) = x
     | unMarkTy x = x


   fun unmark_exp (Ast.VarExp x) = Ast.VarExp x
     | unmark_exp (Ast.FnExp rl) = Ast.FnExp (map unmark_rule rl)
     | unmark_exp (Ast.AppExp {function,argument}) = Ast.AppExp {function=unmark_exp function,argument = unmark_exp argument}
     | unmark_exp (Ast.CaseExp {expr,rules}) = Ast.CaseExp {expr=unmark_exp expr,rules=map unmark_rule rules}
     | unmark_exp (Ast.LetExp {dec,expr}) = Ast.LetExp {dec=unmark_dec dec,expr=unmark_exp expr}
     | unmark_exp (Ast.SeqExp el) = Ast.SeqExp (map unmark_exp el)
     | unmark_exp (Ast.IntExp i) = Ast.IntExp i
     | unmark_exp (Ast.RealExp r) = Ast.RealExp r
     | unmark_exp (Ast.StringExp s) = Ast.StringExp s
     | unmark_exp (Ast.RecordExp sel) = Ast.RecordExp (map (I ## unmark_exp) sel)
     | unmark_exp (Ast.TupleExp el) = Ast.TupleExp (map unmark_exp el)
     | unmark_exp (Ast.SelectorExp x) = Ast.SelectorExp x
     | unmark_exp (Ast.ConstraintExp {expr,constraint}) = Ast.ConstraintExp {expr=unmark_exp expr, constraint=unmark_ty constraint}
     | unmark_exp (Ast.HandleExp {expr,rules}) = Ast.HandleExp {expr=unmark_exp expr,rules=map unmark_rule rules}
     | unmark_exp (Ast.RaiseExp e) = Ast.RaiseExp (unmark_exp e)
     | unmark_exp (Ast.IfExp {test,thenCase,elseCase}) = Ast.IfExp {test=unmark_exp test,thenCase=unmark_exp thenCase,elseCase=unmark_exp elseCase}
     | unmark_exp (Ast.AndalsoExp (l,r)) = Ast.AndalsoExp (unmark_exp l, unmark_exp r)
     | unmark_exp (Ast.OrelseExp (l,r)) = Ast.OrelseExp (unmark_exp l, unmark_exp r)
     | unmark_exp (Ast.VectorExp el) = Ast.VectorExp (map unmark_exp el)
     | unmark_exp (Ast.WhileExp {test,expr}) = Ast.WhileExp {test=unmark_exp test,expr=unmark_exp expr}
     | unmark_exp (Ast.MarkExp (x,_,_)) = unmark_exp x
   and unmark_rule (Ast.Rule {pat,exp}) = Ast.Rule {pat=unmark_pat pat, exp=unmark_exp exp}
   and unmark_pat (Ast.WildPat) = Ast.WildPat
     | unmark_pat (Ast.VarPat x) = Ast.VarPat x
     | unmark_pat (Ast.IntPat x) = Ast.IntPat x
     | unmark_pat (Ast.RealPat x) = Ast.RealPat x
     | unmark_pat (Ast.StringPat x) = Ast.StringPat x
     | unmark_pat (Ast.RecordPat {def,flexibility}) = Ast.RecordPat {def=map(I ## unmark_pat) def,flexibility=flexibility}
     | unmark_pat (Ast.TuplePat pl) = Ast.TuplePat (map unmark_pat pl)
     | unmark_pat (Ast.AppPat {constr,argument}) = Ast.AppPat {constr=constr,argument=unmark_pat argument}
     | unmark_pat (Ast.ConstraintPat {constraint,pattern}) = Ast.ConstraintPat {pattern=unmark_pat pattern,constraint=unmark_ty constraint}
     | unmark_pat (Ast.LayeredPat {varPat,expPat}) = Ast.LayeredPat{varPat=unmark_pat varPat,expPat=unmark_pat expPat}
     | unmark_pat (Ast.VectorPat pl) = Ast.VectorPat (map unmark_pat pl)
     | unmark_pat (Ast.MarkPat (x,_,_)) = unmark_pat x

   and unmark_strexp (Ast.VarStr p) = Ast.VarStr p
     | unmark_strexp (Ast.StructStr d) = Ast.StructStr (unmark_dec d)
     | unmark_strexp (Ast.AppStr (p,l)) = Ast.AppStr (p,map (fn (strexp,b) => (unmark_strexp strexp,b)) l)
     | unmark_strexp (Ast.LetStr (dec,strexp)) = Ast.LetStr (unmark_dec dec,unmark_strexp strexp)
     | unmark_strexp (Ast.MarkStr (strexp,_,_)) = unmark_strexp strexp

   and unmark_fctexp (Ast.VarFct (p,SOME fsigexp)) = Ast.VarFct (p, SOME (unmark_fsigexp fsigexp))
     | unmark_fctexp (Ast.VarFct (p,NONE)) = Ast.VarFct (p, NONE)
     | unmark_fctexp (Ast.FctFct {params,body,constraint}) = 
       Ast.FctFct {params=map (fn (s,sigexp) => (s,unmark_sigexp sigexp)) params,
                   body=unmark_strexp body,
                   constraint=(case constraint of
                                 SOME c => SOME (unmark_sigexp c)
                               | NONE => NONE)}
     | unmark_fctexp (Ast.LetFct (dec,fctexp)) = Ast.LetFct (unmark_dec dec, unmark_fctexp fctexp)
     | unmark_fctexp (Ast.AppFct (p,l,fsigexpo)) = 
       Ast.AppFct(p,map (fn (strexp,b) => (unmark_strexp strexp,b)) l,
                  (case fsigexpo of 
                     SOME fsigexp => SOME (unmark_fsigexp fsigexp)
                   | NONE => NONE))
     | unmark_fctexp (Ast.MarkFct (fctexp,_,_)) = unmark_fctexp fctexp
           
   and unmark_sigexp (Ast.VarSig s) = Ast.VarSig s
     | unmark_sigexp (Ast.SigSig l) = Ast.SigSig (map unmark_spec l)
     | unmark_sigexp (Ast.MarkSig (s,_,_)) = unmark_sigexp s

   and unmark_fsigexp (Ast.VarFsig s) = Ast.VarFsig s
     | unmark_fsigexp (Ast.FsigFsig {param,def}) =
             Ast.FsigFsig {param=map (fn (s,sigexp) => (s,unmark_sigexp sigexp)) param,
                           def=unmark_sigexp def}
     | unmark_fsigexp (Ast.MarkFsig (f,_,_)) = unmark_fsigexp f

   and unmark_spec (Ast.StrSpec l) = Ast.StrSpec (map (fn (s,sigexp) => (s,unmark_sigexp sigexp)) l)
     | unmark_spec (Ast.TycSpec (l,b)) = Ast.TycSpec (map (fn (s,tyvarl) => (s,map (fn tyvar => unmark_tyv tyvar) tyvarl)) l, b)
     | unmark_spec (Ast.FctSpec l) = Ast.FctSpec (map (fn (s,fsigexp) => (s,unmark_fsigexp fsigexp)) l)
     | unmark_spec (Ast.ValSpec l) = Ast.ValSpec (map (fn (s,ty) => (s,unmark_ty ty)) l)
     | unmark_spec (Ast.DataSpec l) = Ast.DataSpec (map unmark_db l)
     | unmark_spec (Ast.ExceSpec l) = Ast.ExceSpec (map (fn (s,tyo) => (s, case tyo of SOME ty => SOME (unmark_ty ty) | NONE => NONE)) l)
     | unmark_spec (Ast.FixSpec f) = Ast.FixSpec f
     | unmark_spec (Ast.ShareSpec l) = Ast.ShareSpec l
     | unmark_spec (Ast.ShatycSpec l) = Ast.ShatycSpec l
     | unmark_spec (Ast.LocalSpec (sl1,sl2)) = Ast.LocalSpec (map unmark_spec sl1, map unmark_spec sl2)
     | unmark_spec (Ast.IncludeSpec s) = Ast.IncludeSpec s
     | unmark_spec (Ast.OpenSpec pl) = Ast.OpenSpec pl
     | unmark_spec (Ast.MarkSpec (s,_,_)) = unmark_spec s


   and unmark_dec (Ast.ValDec vbl) = Ast.ValDec (map unmark_vb vbl)
     | unmark_dec (Ast.ValrecDec l) = Ast.ValrecDec (map unmark_rvb l)
     | unmark_dec (Ast.FunDec l) = Ast.FunDec (map unmark_fb l)
     | unmark_dec (Ast.TypeDec l) = Ast.TypeDec (map unmark_tb l)
     | unmark_dec (Ast.DatatypeDec {datatycs,withtycs}) = Ast.DatatypeDec {datatycs=map unmark_db datatycs,withtycs=map unmark_tb withtycs}
     | unmark_dec (Ast.AbstypeDec {abstycs,withtycs,body}) = Ast.AbstypeDec {abstycs=map unmark_db abstycs, withtycs=map unmark_tb withtycs,body=unmark_dec body}
     | unmark_dec (Ast.ExceptionDec l) = Ast.ExceptionDec (map unmark_eb l)
     | unmark_dec (Ast.StrDec l) = Ast.StrDec (map unmark_strb l)
     | unmark_dec (Ast.AbsDec l) = Ast.AbsDec (map unmark_strb l)
     | unmark_dec (Ast.FctDec l) = Ast.FctDec (map unmark_fctb l)
     | unmark_dec (Ast.SigDec l) = Ast.SigDec (map unmark_sigb l) 
     | unmark_dec (Ast.FsigDec l) = Ast.FsigDec (map unmark_fsigb l) 
     | unmark_dec (Ast.LocalDec (l,r)) = Ast.LocalDec (unmark_dec l, unmark_dec r)
     | unmark_dec (Ast.SeqDec l) = Ast.SeqDec (map unmark_dec l)
     | unmark_dec (Ast.OpenDec pl) = Ast.OpenDec pl
     | unmark_dec (Ast.OvldDec (sym,ty,el)) = Ast.OvldDec (sym,unmark_ty ty,map unmark_exp el)
     | unmark_dec (Ast.FixDec x) = Ast.FixDec x
     | unmark_dec (Ast.ImportDec x) = Ast.ImportDec x
     | unmark_dec (Ast.MarkDec (x,_,_)) = unmark_dec x

   and unmark_vb (Ast.Vb {pat,exp}) = Ast.Vb {pat=unmark_pat pat,exp=unmark_exp exp}
     | unmark_vb (Ast.MarkVb (x,_,_)) = unmark_vb x

   and unmark_rvb (Ast.Rvb {var=var,exp=exp,resultty=SOME resultty}) = Ast.Rvb {var=var,exp=unmark_exp exp,resultty=SOME (unmark_ty resultty)}
     | unmark_rvb (Ast.Rvb {var=var,exp=exp,resultty=NONE}) = Ast.Rvb {var=var,exp=unmark_exp exp,resultty=NONE}
     | unmark_rvb (Ast.MarkRvb (x,_,_)) = unmark_rvb x

   and unmark_fb (Ast.Fb {var,clauses}) = Ast.Fb {var=var,clauses=map unmark_clause clauses}
     | unmark_fb (Ast.MarkFb (x,_,_)) = unmark_fb x

   and unmark_clause (Ast.Clause {pats=pats,resultty=SOME resultty,exp=exp}) = Ast.Clause {pats=map unmark_pat pats,resultty=SOME (unmark_ty resultty),exp=unmark_exp exp}
     | unmark_clause (Ast.Clause {pats=pats,resultty=NONE,exp=exp}) = Ast.Clause {pats=map unmark_pat pats,resultty=NONE,exp=unmark_exp exp}

   and unmark_tb (Ast.Tb {tyc,def,tyvars}) = Ast.Tb {tyc=tyc,def=def,tyvars=map unmark_tyv tyvars}
     | unmark_tb (Ast.MarkTb (x,_,_)) = unmark_tb x

   and unmark_db (Ast.Db {tyc,tyvars,def}) = 
           Ast.Db {tyc=tyc,
                tyvars=map unmark_tyv tyvars,
                def=map (I ## (fn (SOME x) => SOME(unmark_ty x) | NONE => NONE)) def}
     | unmark_db (Ast.MarkDb (x,_,_)) = unmark_db x

   and unmark_eb (Ast.EbGen {exn,etype}) = Ast.EbGen {exn=exn,etype=(fn (SOME x) => SOME(unmark_ty x) | NONE => NONE) etype}
     | unmark_eb (Ast.EbDef x) = Ast.EbDef x
     | unmark_eb (Ast.MarkEb (x,_,_)) = unmark_eb x

   and unmark_strb (Ast.Strb {name,def,constraint}) =
         Ast.Strb {name=name,def=unmark_strexp def,
                   constraint=(case constraint of
                             SOME s => SOME (unmark_sigexp s)
                           | NONE => NONE)}
     | unmark_strb (Ast.MarkStrb (strb,_,_)) = unmark_strb strb
     
   and unmark_fctb (Ast.Fctb {name,def}) = Ast.Fctb {name=name,def=unmark_fctexp def}
     | unmark_fctb (Ast.MarkFctb (f,_,_)) = unmark_fctb f

   and unmark_sigb (Ast.Sigb {name,def}) = Ast.Sigb {name=name,def=unmark_sigexp def}
     | unmark_sigb (Ast.MarkSigb (f,_,_)) = unmark_sigb f

   and unmark_fsigb (Ast.Fsigb {name,def}) = Ast.Fsigb {name=name,def=unmark_fsigexp def}
     | unmark_fsigb (Ast.MarkFsigb (f,_,_)) = unmark_fsigb f

   and unmark_tyv (Ast.Tyv x) = Ast.Tyv x
     | unmark_tyv (Ast.MarkTyv (x,_,_)) = x      

   and unmark_ty (Ast.VarTy x) = Ast.VarTy x
     | unmark_ty (Ast.ConTy (sl,tyl)) = Ast.ConTy (sl,map unmark_ty tyl)
     | unmark_ty (Ast.RecordTy stl) = Ast.RecordTy (map (I ## unmark_ty) stl)
     | unmark_ty (Ast.TupleTy tl) = Ast.TupleTy (map unmark_ty tl)
     | unmark_ty (Ast.MarkTy (x,_,_)) = x

   fun DSymExp x = x;
   fun DSymPat x = x;
   fun DSymbol x = System.Symbol.name x;

   fun DSOME (SOME x) = x;
   fun DNONE NONE = ();

   val DVarExp = (fn (Ast.VarExp x) => x) o unMarkExp
   val DFnExp = (fn (Ast.FnExp x) => x) o unMarkExp
   val DAppExp = (fn (Ast.AppExp {function,argument}) => (function,argument)) o unMarkExp
   val DCaseExp = (fn (Ast.CaseExp {expr,rules}) => (expr,rules)) o unMarkExp
   val DLetExp = (fn (Ast.LetExp {dec,expr}) => (dec,expr)) o unMarkExp
   val DSeqExp = (fn (Ast.SeqExp x) => x) o unMarkExp
   val DIntExp = (fn (Ast.IntExp x) => x) o unMarkExp
   val DRealExp = (fn (Ast.RealExp x) => x) o unMarkExp
   val DStringExp = (fn (Ast.StringExp x) => x) o unMarkExp
   val DRecordExp = (fn (Ast.RecordExp x) => x) o unMarkExp
   val DTupleExp = (fn (Ast.TupleExp x) => x) o unMarkExp
   val DSelectorExp = (fn (Ast.SelectorExp x) => x) o unMarkExp
   val DConstraintExp = (fn (Ast.ConstraintExp {expr,constraint}) => (expr,constraint)) o unMarkExp
   val DHandleExp = (fn (Ast.HandleExp {expr,rules}) => (expr,rules)) o unMarkExp
   val DRaiseExp = (fn (Ast.RaiseExp x) => x) o unMarkExp
   val DIfExp = (fn (Ast.IfExp {test,thenCase,elseCase}) => (test,thenCase,elseCase)) o unMarkExp
   val DAndalsoExp = (fn (Ast.AndalsoExp x) => x) o unMarkExp
   val DOrelseExp = (fn (Ast.OrelseExp x) => x) o unMarkExp
   val DVectorExp = (fn (Ast.VectorExp x) => x) o unMarkExp
   val DWhileExp = (fn (Ast.WhileExp {test,expr}) => (test,expr)) o unMarkExp
   val DMarkExp = (fn (Ast.MarkExp x) => x) o unMarkExp

   fun DRule (Ast.Rule {pat,exp}) = (pat,exp)

   val DWildPat = (fn (Ast.WildPat) => ()) o unMarkPat
   val DVarPat = (fn (Ast.VarPat x) => x) o unMarkPat
   val DIntPat = (fn (Ast.IntPat x) => x) o unMarkPat
   val DRealPat = (fn (Ast.RealPat x) => x) o unMarkPat
   val DStringPat = (fn (Ast.StringPat x) => x) o unMarkPat
   val DRecordPat = (fn (Ast.RecordPat {def,flexibility}) => (def,flexibility)) o unMarkPat
   val DTuplePat = (fn (Ast.TuplePat x) => x) o unMarkPat
   val DAppPat = (fn (Ast.AppPat {constr,argument}) => (constr,argument)) o unMarkPat
   val DConstraintPat = (fn (Ast.ConstraintPat {constraint,pattern}) => (pattern,constraint)) o unMarkPat
   val DLayeredPat = (fn (Ast.LayeredPat {varPat,expPat}) => (varPat,expPat)) o unMarkPat
   val DVectorPat = (fn (Ast.VectorPat x) => x) o unMarkPat
   val DMarkPat = (fn (Ast.MarkPat x) => x) o unMarkPat

   val DTyv = (fn (Ast.Tyv x) => x) o unMarkTyv
   val DMarkTyv = (fn (Ast.MarkTyv x) => x) o unMarkTyv

   val DVarTy = (fn (Ast.VarTy x) => x) o unMarkTy
   val DConTy = (fn (Ast.ConTy x) => x) o unMarkTy
   val DRecordTy = (fn (Ast.RecordTy x) => x) o unMarkTy
   val DTupleTy = (fn (Ast.TupleTy x) => x) o unMarkTy
   val DMarkTy = (fn (Ast.MarkTy x) => x) o unMarkTy

   val DValDec = (fn (Ast.ValDec x) => x) o unMarkDec
   val DValrecDec = (fn (Ast.ValrecDec x) => x) o unMarkDec
   val DFunDec = (fn (Ast.FunDec x) => x) o unMarkDec
   val DTypeDec = (fn (Ast.TypeDec x) => x) o unMarkDec
   val DDatatypeDec = (fn (Ast.DatatypeDec {datatycs,withtycs}) => (datatycs,withtycs)) o unMarkDec
   val DAbstypeDec = (fn (Ast.AbstypeDec {abstycs,withtycs,body}) => (abstycs,withtycs,body)) o unMarkDec
   val DExceptionDec = (fn (Ast.ExceptionDec x) => x) o unMarkDec
   val DStrDec = (fn (Ast.StrDec x) => x) o unMarkDec
   val DAbsDec = (fn (Ast.AbsDec x) => x) o unMarkDec
   val DFctDec = (fn (Ast.FctDec x) => x) o unMarkDec
   val DSigDec = (fn (Ast.SigDec x) => x) o unMarkDec
   val DFsigDec = (fn (Ast.FsigDec x) => x) o unMarkDec
   val DLocalDec = (fn (Ast.LocalDec x) => x) o unMarkDec
   val DSeqDec = (fn (Ast.SeqDec x) => x) o unMarkDec
   val DOpenDec = (fn (Ast.OpenDec x) => x) o unMarkDec
   val DOvldDec = (fn (Ast.OvldDec x) => x) o unMarkDec
   val DFixDec = (fn (Ast.FixDec {fixity,ops}) => (fixity,ops)) o unMarkDec
   val DImportDec = (fn (Ast.ImportDec x) => x) o unMarkDec

   val DVb = (fn (Ast.Vb {pat,exp}) => (pat,exp)) o unMarkVb

   val DRvb = (fn (Ast.Rvb {var,exp,resultty}) => (var,exp,resultty)) o unMarkRvb

   val DFb = (fn (Ast.Fb {var,clauses}) => (var,clauses)) o unMarkFb

   val DClause = (fn (Ast.Clause {pats,resultty,exp}) => (pats,resultty,exp))

   val DTb = (fn (Ast.Tb {tyc,def,tyvars}) => (tyc,def,tyvars)) o unMarkTb

   val DDb = (fn (Ast.Db {tyc,tyvars,def}) => (tyc,tyvars,def)) o unMarkDb
   fun DDbDef x = x

   val DEbGen = (fn (Ast.EbGen {exn,etype}) => (exn,etype)) o unMarkEb
   val DEbDef = (fn (Ast.EbDef {exn,edef}) => (exn,edef)) o unMarkEb
 
   fun DPath x = x
   fun last [h] = h
     | last (h::t) = last t
   fun DRules x = x

   fun D2TupleExp x = 
      let val [a,b] = DTupleExp x in (a,b) end;
   fun DNil x = 
      let val [symbol] = DVarExp x
          val "nil" = DSymbol symbol
      in
         ()
      end;
   fun DCons x = 
      let val (varexp,args) = DAppExp x
          val [symbol] = DVarExp varexp
          val "::" = DSymbol symbol
          val (hd,tl) = D2TupleExp args
      in
          (hd,tl)
      end
   fun DQuote x =
      let val (varexp,v) = DAppExp x
          val [symbol] = DVarExp varexp
          val "QUOTE" = DSymbol symbol
      in
          v
      end;
   fun DAntiquote x =
      let val (varexp,v) = DAppExp x
          val [symbol] = DVarExp varexp
          val "ANTIQUOTE" = DSymbol symbol 
      in
          v
      end;
   fun DFragList x = 
      let val (hd,tl) = DCons x
          val _ = DQuote hd handle _ => DAntiquote hd
      in
         hd::DFragList tl
      end
      handle _ =>
      let val _ = DNil x
      in
         []
      end;
   fun DList x = 
      let val (hd,tl) = DCons x
      in
         hd::DList tl
      end
      handle _ =>
      let val _ = DNil x
      in
         []
      end;
end;
end;


structure SMLConstructors = struct end;
structure SMLExternals = struct 
local
   open System.Env;
   open System.Symbol;
in
   val infixes = ref
["##","ORELSE","ORELSEC","ORELSE_TCL","THEN","THENC","THENL","THEN_TCL","|->",
 "*","+","-","/","::",":=","<","<=","<>",
 "=",">",">=","@","^","before","div",
 "mod","o","quot","rem","addrewrs","addcongrules","merge_ss","|>",">-"];
   val real_to_string = Real.makestring;
   val int_to_string = Integer.makestring;
   fun is_infix x = mem x  (!infixes);
   fun add_infix x = (infixes := x::(!infixes));

   fun is_parser x = (mem x ["---","===","--","-|","=="]);
end;
end;



structure SMLStringTable = struct 
       exception StringTable;
       fun lookup s = (s,String.length s)
       fun attrib _ = (fn _ => raise StringTable);

       fun is _ = (fn _ => raise StringTable);

end;


local
open System.Compile;
open System.PrettyPrint;
open System.Env;
open System.Ast;
open System.Symbol;
in
fun parse_exp input =
   let val error_consumer = {
            consumer= curry output std_err,
            flush= fn () => (),
            linewidth=80
           }
       val source = makeSource("mk_file", 1, open_string input, false, error_consumer)
       val (parsetree,newenv) = parse(source,staticPart(layerEnv (!topLevelEnvRef, !pervasiveEnvRef)))
       val SeqDec [MarkDec (ValDec [Vb {exp=exp,pat=_}],_,_)] = parsetree

   in
       exp
   end;
fun parse_dec input =
   let val error_consumer = {
            consumer= curry output std_err,
            flush= fn () => (),
            linewidth=80
           }
       val source = makeSource("mk_file", 1, open_string input, false, error_consumer)
       val (parsetree,newenv) = parse(source,staticPart(concatEnv (!topLevelEnvRef, !pervasiveEnvRef)))
       val SeqDec [MarkDec (dec,_,_)] = parsetree

   in
       dec
   end;
end;
   
