(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)



signature BwdProofs_sig = sig
    type tac sharing type tac = string
    datatype bwdproof = BWDPROOF of bwdop list
    and bwdop = BWDTHENL of bwdproof list | 
                BWDTAC of tac
(*    val layout_proof : bwdproof -> string *)
end


signature PartialBwdProofs_sig = sig
    structure BwdProofs : BwdProofs_sig
    datatype pbwdproof = PBWDPROOF of (int * pbwdop list)
    and pbwdop = PBWDTHENL of pbwdproof list | 
                 PBWDTAC of BwdProofs.tac
    exception PROOF_IS_PARTIAL

    val chop : int -> 'a list -> 'a list

    val pbwdproof_to_bwdproof : pbwdproof -> BwdProofs.bwdproof
    val pbwdop_to_bwdop : pbwdop -> BwdProofs.bwdop

    val harden_pbwdproof : pbwdproof -> pbwdproof
    val harden_pbwdop : pbwdop -> pbwdop

    val bwdproof_to_soft_pbwdproof : BwdProofs.bwdproof -> pbwdproof 
    val bwdop_to_soft_pbwdop : BwdProofs.bwdop -> pbwdop 

    val bwdproof_to_hard_pbwdproof : BwdProofs.bwdproof -> pbwdproof 
    val bwdop_to_hard_pbwdop : BwdProofs.bwdop -> pbwdop 
end

