

%{

#define OTHER 257
#define DOUBLE_SEMICOLON 258
#define RETURN(x) { return x; }

static int comment_depth;

%}


%x NESTED_COMMENT NONNESTED_COMMENT STRING TERM

%%


"%<"			{ BEGIN(NESTED_COMMENT); comment_depth = 1; }
"%"			{ BEGIN(NONNESTED_COMMENT); }
[ \t\n\r]+              {  }
<NESTED_COMMENT>"%<"    { comment_depth++; }
<NESTED_COMMENT>">%"    { comment_depth--; 
                          if (comment_depth == 0) { 
                              BEGIN(INITIAL); 
                          }
                        }
<NESTED_COMMENT><<EOF>> { printf("unmatched \"%%<\" comment\n"); exit(1); }
<NESTED_COMMENT>.       { }

<NONNESTED_COMMENT>"%"    { BEGIN(INITIAL); }
<NONNESTED_COMMENT><<EOF>> { printf("unmatched \"%%\" comment\n"); exit(1); }
<NONNESTED_COMMENT>.       { }

\`                      { BEGIN(STRING); }
<STRING>\`              { BEGIN(INITIAL); RETURN(OTHER); }            
<STRING>\\\`            { }            
<STRING><<EOF>>         { printf("unclosed string\n"); exit(1); }            
<STRING>.               { }            

\"                      { BEGIN(TERM); }
<TERM>\"              { BEGIN(INITIAL); }            
<TERM>\\\"            { RETURN(OTHER); }            
<TERM><<EOF>>         { printf("unclosed term\n"); exit(1); }            
<TERM>.               { }            

\;\;+                 { RETURN(DOUBLE_SEMICOLON); }
.                       { RETURN(OTHER); }

%%

int main( argc, argv )
int argc;
char **argv;
{
        int count,token,last_token;

        count = 0;
        last_token = DOUBLE_SEMICOLON;
        while (token = yylex()) {
            if (token==DOUBLE_SEMICOLON) { count++; }
            last_token=token;
        }
        if (last_token == DOUBLE_SEMICOLON) {
            printf("%d\n", count);
        } else {
            printf("last command was not completed\n"); 
            return 1; 
        }
        return 0;
}

