#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




proc tkhol_slave::ProcessArgs { argc argv } {
        global tkhol_slave_flags 
        global tksml_slave_flags 
        global gui_flags

        if [info exists tkhol_slave_flags(default_hol)] {
            set default_hol $tkhol_slave_flags(default_hol)
        } else {
            set default_hol "hol90"
        }
        if {[llength [info commands Preferences_Add]]==1} {
            Preferences_Add "Start Up" "Preferences related to how the underlying HOL process is run are set here.  Most changes to these options will only take effect after you restart $gui_flags(title). " \
                [list \
                    [list tksml_slave_flags(ml) tkHolSlaveHol STRING $default_hol "HOL executable" "The HOL executable to use at startup.  This may be overriden by the -ml command line option."] \
             ]
            Preferences_Add "Managing Scripts" "" \
                [list \
                    [list TkHol_flags(managingScripts) managingScripts BOOL 0 "Manage Scripts" "If this is true $gui_flags(title) will create and manage theory scripts for you as you make definitions and prove results.  You will always be prompted first before fragments are added to script files."] \
                    [list TkHol_flags(scriptPattern) scriptFilePattern STRING "mk_%F.sml" "Pattern for determining the name of a script file" "A pattern which guides $gui_flags(title)'s construction of script file names which record the creation of a theory."] \
                    [list TkHol_flags(addHeadersToScripts) addHeadersToScripts BOOL 1 "Add Comment Headers" "If this is true comment headers will be added before any script fragments are appended to script files."] \
             ]
        }       
        for {set arg 0} {$arg < $argc} {incr arg} {
            switch -- [lindex $argv $arg] -theory {
                incr arg
                set tkhol_slave_flags(initial_theory) [lindex $argv $arg] 
            } -library {
                incr arg
                lappend tkhol_slave_flags(libraries) [lindex $argv $arg] 
            }
        }

        switch -- $tksml_slave_flags(mltype_strategy) infer {
            switch -glob -- $tksml_slave_flags(ml) *hol88* {
              set tkhol_slave_flags(holtype) hol88
            } hol {
              set tkhol_slave_flags(holtype) hol88
            } *hol90* {
              set tkhol_slave_flags(holtype) hol90
            } default {
              puts stderr "\nNote: $gui_flags(title) couldn't automatically determine the HOL type of  $tksml_slave_flags(ml) so $gui_flags(title) is assuming it's hol90.  Use \"-holtype hol88\" if this is wrong.\n"
              set tkhol_slave_flags(holtype) hol90
            }
        } hol88 {
            set tkhol_slave_flags(holtype) hol88
        } hol90 {
            set tkhol_slave_flags(holtype) hol90
        } default {
            puts stderr "\n$gui_flags(title) internal error - strange value for $tkhol_slave_flags(holtype_strategy).  Assuming holtype is hol90."
            set tkhol_slave_flags(holtype) hol90
        }
        # puts "ml = $tksml_slave_flags(ml)"
        # puts "mltype_strategy = $tksml_slave_flags(mltype_strategy)"
        # puts "mltype = $tkhol_slave_flags(holtype)"

        set tkhol_slave_flags(hol88) 0
        set tkhol_slave_flags(hol90) 0
        switch -- $tkhol_slave_flags(holtype) hol88 {
            set tkhol_slave_flags(hol88) 1
        } hol90 {
            set tkhol_slave_flags(hol90) 1
        } 

}


proc tkhol_slave::InitialisePackage { args } {
        global tkhol_slave_library
        global tkhol_slave_flags
        global TkHol_flags
        
        tksml_slave::register_exception_filter {handle e => Raise e}

        if [hol90] {
            tksml_slave::register_error_string "Exception raised at.*"
            tksml_slave::register_error_string "Unconstrained type variable in.*"
            tksml_slave::register_error_string "Type inference failure.*"
            tksml_slave::register_feedback_string {Loading the library [^\n]*\.}
            ML -toplevel 1 "
                System.Print.signatures := 0;
                Globals.library_path := \n(!Globals.library_path)@\n\[[ml_string $tkhol_slave_library/]\];
                prim_load_library Lib.interpret \{lib=find_library [ml_string tkhol],theory=\"-\"\};
                open TkHol;
                System.Print.signatures := 2
            "
        } 
        if [hol88] {
            tksml_slave::register_error_string "Indeterminate types.*"
            tksml_slave::register_error_string "HOL Error.*"
        }
        set TkHol_flags(script_traces) ""
}       


proc interface_on { } {
    global busy feedback
    incr busy
    set feedback [list {} "Please wait..."]
    newwin TkTheoryViewer
    incr busy -1
}

proc interface_off { } {
    global busy feedback
    incr busy
    set feedback [list {} "Please wait..."]
    foreach win [info commands .?*] { 
        catch {
           if {[winfo toplevel $win]!={.}} { 
                catch {destroy [winfo toplevel $win]} 
           } 
        }
    }
    incr busy -1
}


