#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File: modal.tcl

# Description:
#       Procedures for operating modal dialog boxes.

 # modal.nw,v 1.3 1995/07/14 03:48:34 drs1004 Exp
 # /homes/drs1004/repository/tkaux/src/modal.nw,v
 # modal.nw,v
# Revision 1.3  1995/07/14  03:48:34  drs1004
# if this is it...
# please let me know...
# if this aint love you'd better just say so...
#
# Revision 1.2  1995/06/24  23:08:00  drs1004
# A whole lot of work.  Why did it take me so long
# to check all this stuff in?  It's been months!
#
# Slowly but surely heading for a release in a month or so.
# By then I'll have proof replay and Z working.  Alright!
#
# Revision 1.1  1995/06/09  18:10:53  drs1004
# documentation and cleanup of unwanted things.
#
# Revision 1.1  1995/05/24  17:09:38  drs1004
# tosrc
#
# Revision 1.3  1995/03/21  15:04:59  drs1004
# Patch 1, 0.2b.  Bug fixes suggested by Michael Norrish.
#
# Revision 1.2  1995/03/01  11:33:59  drs1004
# Phew.
#
# Revision 1.1.1.1  1994/12/07  10:17:29  donald
# First import after some small chanegs.
#
 # Revision 1.13  1994/10/27  18:29:42  kennykb
 # Release 2.0 -- 10-27-94.  To be uploaded to archive sites.
 #
 # Revision 1.12  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.11  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.10  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.9  1993/10/20  19:02:14  kennykb
 # Changed so that modalDialog doesn't wait for window visibility.  NOTE:
 # It won't work if the window isn't visible, but since the usual usage is
 # `modalDialog transient' and transient must wait for the visibility,
 # this should be OK.
 #
 # Revision 1.8  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.7  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.6  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.5  1993/10/14  13:41:14  kennykb
 # Changed to use widget_checkAndDestroy to avoid repeated destruction of the
 # same widget.
 #
 # Revision 1.4  1993/07/21  19:44:36  kennykb
 # Finished cleaning up structured commentary.
 #
 # Revision 1.3  1993/07/20  19:17:12  kennykb
 # Improved structured comments.
 # Changed modules through `g' in the alphabet to follow `:' and `_' naming
 # conventions.
 #
 # Revision 1.2  1993/07/19  18:49:24  kennykb
 # Renamed all button_ commands to either button. or button:, in
 # conformance with new module naming conventions.
 #
 # Revision 1.1  1993/06/03  15:30:35  kennykb
 # Initial revision
 #

# Procedure:    modalDialog
#
# Synopsis:
#       Make a widget operate as a modal dialog.
#
# Usage:
#c      modalDialog command args...
#
# Parameters:
#       A command that creates a widget.
#
# Return value:
#       The name of the widget.
#
# Description:
#       modalDialog modifies the behavior of another widget creation command
#       so that it operates as a modal dialog box.  The focus is saved and
#       set to the widget's default focus; the widget is grabbed; the
#       widget's default button is set.
#
# See also:
#       modalDialog.end is used to release a modal dialog.
#
# Example:
#
#c      proc getanswer {} {

#c              global getanswer_priv

#c              modalDialog transient choicebox .query \

#c                      -text "Are you sure?" \

#c                      -buttons {Yes No} \

#c                      -icon think \

#c                      -textvariable getanswer_priv

#c              widget_waitVariable getanswer_priv

#c              set result $getanswer_priv

#c              modalDialog.end .query

#c              unset getanswer_priv

#c              return $result

#c      }

proc modalDialog {args} {
        global modal_priv
        set focus [focus_findCurrent]
        focus none
        set w [uplevel 1 $args]
        set modal_priv(focus,$w) $focus
        set modal_priv(grab,$w) [grab current $w]
        grab set $w
        
        button_setDefault $w

        if {[wm protocol $w WM_DELETE_WINDOW]==""} {
            wm protocol $w WM_DELETE_WINDOW "if \[catch \{$w cancel\}\] \{ destroy $w \}"
        }
        focus_goToFirst $w
        return $w
}

# Procedure:    modalDialog.end
#
# Synopsis:
#       Release a modal dialog.
#
# Usage:
#c      modalDialog.end pathName
#
# Parameters:
#c      pathName
#               Name of a widget that has been made modal via modalDialog
#
# Return value:
#       None.
#
# Description:
#       modalDialog.end ends a modal dialog.  It releases a grab on the
#       specified widget, directs the focus to where it was before the
#       modal dialog began, and destroys the widget.
#
# Bugs:
#       Widget destruction should be orthogonal to the modal dialog. (?)

proc modalDialog.end w {
        global modal_priv
        grab release $w
        if {$modal_priv(grab,$w) != ""} {
                grab set $modal_priv(grab,$w)
        }
        unset modal_priv(grab,$w)
        
        catch {focus_goTo $modal_priv(focus,$w) -force}
        after 1 "
                after 1 widget_checkAndDestroy $w
        "
        unset modal_priv(focus,$w)
}
