#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




option add *TheoremSaveBox.header "" widgetDefault
option add *TheoremSaveBox.resultsvariable results widgetDefault

proc TheoremSaveBox { w args } {
        global vals 
        global gui_flags
        global TkHol_flags


        for {set i 0} {$i<[llength $args]} {incr i} {
            switch -- [lindex $args $i] -header {
                incr i
                set header [lindex $args $i]
            } -savename {
                incr i
                set savename [lindex $args $i]
            } -resultsvariable {
                incr i
                set vals($w,resultsvariable) [lindex $args $i]
            } default {
                error "unrecognized arg [lindex $args $i]"
            }
        }
        frame $w -class TheoremSaveBox
        if ![info exists header] { set header [option get $w header Header] }
        if ![info exists vals($w,resultsvariable)] { set vals($w,resultsvariable) [option get $w resultsvariable ResultsVariable] }

        pack [label $w.header \
                -text $header \
                -font $gui_flags(font,labels) ] \
            -side top -padx 10 -pady 10
            

        pack [frame $w.options -borderwidth 2 -relief sunken] -side top -pady 10
        pack [frame $w.options.save] -side top -padx 10 -fill x -expand yes
        pack [fontcheck entry $w.options.save.name \
                -font $gui_flags(font,textentry) \
                -relief sunken] \
            -side right -expand yes -fill x

        if [info exists savename] {
            $w.options.save.name insert 0 $savename
        }
        if ![info exists vals(TheoremSaveBox,save)] {
            set vals(TheoremSaveBox,save) 1
        }
        pack [fontcheck focusable checkbutton $w.options.save.cb \
                -width 20 \
                -text "Save to theory as: " \
                -variable vals(TheoremSaveBox,save) \
                -font $gui_flags(font,buttons) \
                -relief flat \
                -anchor w] \
            -side left -fill x

        if ![info exists vals(TheoremSaveBox,bind)] {
            set vals(TheoremSaveBox,bind) 1
        }
        pack [fontcheck focusable checkbutton $w.options.bind \
                -text "Bind to corresponding ML identifier" \
                -variable vals(TheoremSaveBox,bind) \
                -font $gui_flags(font,buttons) \
                -relief flat \
                -anchor w] \
            -fill x -expand yes -padx 10

        global TkHol_flags
        if ![info exists vals(TheoremSaveBox,append)] {
           set vals(TheoremSaveBox,append) $TkHol_flags(managingScripts)
        }
        pack [fontcheck focusable checkbutton $w.options.append \
                -text "Append to [Scripts::current_script]" \
                -variable vals(TheoremSaveBox,append) \
                -font $gui_flags(font,buttons) \
                -relief flat \
                -anchor w] \
            -fill x -expand yes -padx 10

        if ![info exists vals(TheoremSaveBox,view_script)] {
            set vals(TheoremSaveBox,view_script) [expr !$TkHol_flags(managingScripts)]
        }
        pack [fontcheck focusable checkbutton $w.options.view_script \
                -text "View script" \
                -variable vals(TheoremSaveBox,view_script) \
                -font $gui_flags(font,buttons) \
                -relief flat \
                -anchor w] \
            -fill x -expand yes -padx 10

        pack [frame $w.controls] -side bottom -pady 10
        pack [fontcheck focusable button $w.controls.ok \
                -width 6 \
                -text Ok \
                -command "TheoremSaveBox::Ok $w" \
                -font $gui_flags(font,buttons)] \
            -side left \
            -padx 10
        pack [fontcheck focusable button $w.controls.cancel \
                -width 6 \
                -text Cancel \
                -command "set $vals($w,resultsvariable) Cancel" \
                -font $gui_flags(font,buttons)] \
            -side left \
            -padx 10
        wm protocol [winfo toplevel $w] WM_DELETE_WINDOW "set $vals($w,resultsvariable) Cancel"
        button_setDefault $w.controls.ok
        focus_goToFirst $w
        bind $w <Destroy> "unset_vals_for_widget $w"
}

proc TheoremSaveBox::Ok { w } {
        global vals
        set savename [$w.options.save.name get]
        if {($vals(TheoremSaveBox,save) || $vals(TheoremSaveBox,bind)) && ![regexp {([A-Z]|[a-z])([A-Z]|[a-z]|[0-9]|_)*} $savename]} {
                errormessage $w.error "You must specify a valid ML identifier for the theorem name"
                return
        }
        upvar #0 $vals($w,resultsvariable) var
        set var [list Ok $vals(TheoremSaveBox,save) $savename $vals(TheoremSaveBox,bind) $vals(TheoremSaveBox,view_script) $vals(TheoremSaveBox,append)]
}

