#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




proc TkGoalProof::ProcessArgs { argc argv } {
        global TkGoalProof_flags
        global TkGoalProof_tactic_history
        global TkGoalProof_goal_history
        global gui_flags

        if {[llength [info commands Preferences_Add]]==1} {

            Preferences_Add "TkGoalProof" " \
Options concerning TkGoalProof may be specified here." \
                [list \
                    [list TkGoalProof_flags(expandgoals) expandGoals \
                        [list CHOICE All First None] First "Initial Goal Expansion"  \
                        "How many goals to expand each time a new set of goals is generated" \
                    ] \
                    [list TkGoalProof_flags(detectNoChange) detectNoChange \
                        BOOL 1 "Detect pointless tactic applications"  \
                        "If this option is set, applying a tactic which has no effect on the set of goals will be reported as an error." \
                    ] \
                ]
                

            Preferences_Add "User Specified Tactics" " \
Commonly used tactics may be specified \
here for inclusion in various $gui_flags(title) tools. \
Several groups of tactics may be specified.  Many common tactics \
built into the HOL system are specified by default.\n\
\nIf a tactic includes text surrounded by \"<\" \">\" characters then \
this indicates that the tactic should not be applied immediately \
when selected. \
In the case of TkGoalProof it will be inserted into the \"Next Tactic\" window to \
await possible further modification.  The \"<...>\" text will \
be removed and the cursor will be placed at this location \
within the tactic text." \
                [list \
                    [list TkGoalProof_flags(tactics1,title) tactics1Title \
                        STRING "Rewrite" "Common Tactics (1) Title" \
                        "The title of the first list of commonly used tactics." \
                    ] \
                    [list TkGoalProof_flags(tactics1) tactics1 \
                        LIST [list \
                                {REWRITE_TAC [<thms>]} \
                                {ASM_REWRITE_TAC [<thms>]} \
                                {ONCE_REWRITE_TAC [<thms>]} \
                                {ONCE_ASM_REWRITE_TAC [<thms>]} \
                                {PURE_REWRITE_TAC [<thms>]} \
                                {PURE_ASM_REWRITE_TAC [<thms>]} \
                                {PURE_ONCE_REWRITE_TAC [<thms>]} \
                                {PURE_ONCE_ASM_REWRITE_TAC [<thms>]} \
                                {Configureable - see the Options menu...} \
                        ] "Common Tactics (1)" "A list of commonly used tactics available for the user to specify. If the list is empty it will not appear in various tools." \
                    ] \
                    [list TkGoalProof_flags(tactics2,title) tactics2Title \
                        STRING "General" "Common Tactics (2) Title" \
                        "The title of the second list of commonly used tactics." \
                    ] \
                    [list TkGoalProof_flags(tactics2) tactics2 \
                        LIST [list \
                                {ASM_CASES_TAC <term>} \
                                {ASSUME_TAC} \
                                {BETA_TAC} \
                                {CONJ_TAC} \
                                {CONV_TAC <conv>} \
                                {DISCH_TAC} \
                                {DISJ_CASES_TAC <thm>} \
                                {EQ_TAC} \
                                {EXISTS_TAC <term>} \
                                {GEN_TAC} \
                                {IMP_RES_TAC <thm>} \
                                {MATCH_MP_TAC <thm>} \
                                {CONV_TAC (DEPTH_CONV (BETA_CONV ORELSEC PAIRED_BETA_CONV))} \
                                {STRIP_TAC} \
                                {UNDISCH_TAC <term>} \
                                {Configureable - see the Options menu...} \
                        ] "Common Tactics (2)" "A list of commonly used tactics available for the user to specify. If the list is empty it will not appear in various tools." \
                    ] \
                    [list TkGoalProof_flags(tactics3,title) tactics3Title \
                        STRING "User" "Common Tactics (3) Title" \
                        "The title of the fourth list of commonly used tactics." \
                    ] \
                    [list TkGoalProof_flags(tactics3) userTactics3 \
                        LIST [list "Configurable - see the Options menu..."] "Common Tactics (3)" "A list of commonly used tactics available for the user to specify. If the list is empty it will not appear in various tools." \
                    ] \
                    [list TkGoalProof_flags(tactics4,title) tactics4Title \
                        STRING "Tactics (4)" "Common Tactics (4) Title" \
                        "The title of the fourth list of commonly used tactics." \
                    ] \
                    [list TkGoalProof_flags(tactics4) userTactics4 \
                        LIST "" "Common Tactics (4)" "A list of commonly used tactics available for the user to specify. If the list is empty it will not appear in various tools." \
                    ] \
                ]
                
                
            Preferences_Add "Tactic/Goal History" " \
The history of applied tactics and goals may be viewed and \
edited here.  There is not alot of point in editing the \
actual list itself, although the other options may be useful." \
                [list \
                    [list TkGoalProof_flags(tactic_history,title) tacticHistoryTitle \
                        STRING "History" "Tactic History Title" \
                        "The title of the tactic history list." \
                    ] \
                    [list TkGoalProof_flags(tactic_history,depth) tacticHistoryDepth \
                        NUM "40" "Tactic History Depth" \
                        "The maximum number of tactics stored in the tactic history list." \
                    ] \
                    [list TkGoalProof_tactic_history {FILE .tkhol-tactic-history} \
                        LIST "" "Tactic History" "The history of tactics applied through the user interface.  This gets changed dynamically by TkHolWorkbench." \
                    ] \
                    [list TkGoalProof_flags(goal_history,title) goalHistoryTitle \
                        STRING "History" "Goal History Title" \
                        "The title of the goal history list." \
                    ] \
                    [list TkGoalProof_flags(goal_history,depth) goalHistoryDepth \
                        NUM "40" "Goal History Depth" \
                        "The maximum number of goals stored in the goal history list." \
                    ] \
                    [list TkGoalProof_goal_history {FILE .tkhol-goal-history} \
                        LIST "" "Goal History" "The history of goals applied through the user interface.  This gets changed dynamically by TkHolWorkbench." \
                    ] \
                ]
                
                
                
            Preferences_Add "User Specified Conversions" " \
Commonly used conversions may be specified \
here for inclusion in various $gui_flags(title) tools. \
Several groups of conversions may be specified.  Many common conversions \
built into the HOL system are specified by default.  Some of these \
are not available unless the appropriate library has been loaded.\n\
\nIf a conversion includes the text \"...\" then \
this indicates that the conversion should not be applied immediately \
when selected. " \
                [list \
                    [list TkGoalProof_flags(conversions1,title) conversions1Title \
                        STRING "Conversions" "Common Conversions (1) Title" \
                        "The title of the first list of commonly used conversions." \
                    ] \
                    [list TkGoalProof_flags(conversions1) conversions1 \
                        LIST [list \
                                {BETA_CONV} \
                                {FUN_EQ_CONV} \
                                {let_CONV} \
                                {num_CONV} \
                                {PAIRED_BETA_CONV} \
                                {REWRITE_CONV [<thms>]} \
                                {ONCE_REWRITE_CONV [<thms>]} \
                                {PURE_REWRITE_CONV [<thms>]} \
                                {PURE_ONCE_REWRITE_CONV [<thms>]} \
                        ] "Common Conversions (1)" "A list of commonly accessed conversions, which the user may specify." \
                    ] \
                    [list TkGoalProof_flags(conversions2,title) conversions2Title \
                        STRING "Conversions (2)" "Common Conversions (2) Title" \
                        "The title of the first list of commonly used conversions." \
                    ] \
                    [list TkGoalProof_flags(conversions2) conversions2 \
                        LIST "" "Common Conversions (2)" "A list of commonly accessed conversions, which the user may specify. If the list is empty it will not appear in various tools." \
                    ] \
                ]
                
                
#           Preferences_Add "User Specified Tacticals" " \
#Commonly used tacticals may be specified \
#here for inclusion in various $gui_flags(title) tools. \
#Several groups of tacticals may be specified.  Many common tacticals \
#built into the HOL system are specified by default.\n\
#\nIf a tactical includes the text \"...\" then \
#this indicates that the tactical should not be applied immediately \
#when selected. " \
#               [list \
#                   [list TkGoalProof_flags(tacticals1,title) tacticals1Title \
#                       STRING "Tacticals" "Common Tacticals (1) Title" \
#                       "The title of the first list of commonly used tacticals." \
#                   ] \
#                   [list TkGoalProof_flags(tacticals1) tacticals1 \
#                       LIST [list \
#                               {INDUCT_THEN} \
#                               {REPEAT} \
#                               {THEN} \
#                               {TRY} \
#                       ] "Common Tacticals (1)" "A list of commonly used tacticals, which the user may specify."\
#                   ] \
#                   [list TkGoalProof_flags(tacticals2,title) tacticals2Title \
#                       STRING "General Tacticals" "Common Tacticals (2) Title" \
#                       "The title of the first list of commonly used tacticals." \
#                   ] \
#                   [list TkGoalProof_flags(tacticals2) tacticals2 \
#                       LIST "" "Common Tacticals (2)" "A list of commonly accessed tacticals, which the user may specify. If the list is empty it will not appear in various tools." \
#                   ] \
#               ]
#            
                
            Preferences_Add "User Specified Rules" " \
Commonly used rules may be specified \
here for inclusion in various $gui_flags(title) tools. \
Several groups of rules may be specified.  Many common rules \
built into the HOL system are specified by default.\n\
\nIf a rule includes the text \"...\" then \
this indicates that the rule should not be applied immediately \
when selected. " \
                [list \
                    [list TkGoalProof_flags(rules1,title) rules1Title \
                        STRING "General Rules" "Common Rules (1) Title" \
                        "The title of the first list of commonly used rules." \
                    ] \
                    [list TkGoalProof_flags(rules1) rules1 \
                        LIST [list \
                                {ISPECL [...]} \
                                {GEN ...} \
                                {GEN_ALL} \
                                {GSYM ...} \
                                {MATCH_MP ...} \
                                {SPEC ...} \
                                {SPEC_ALL} \
                                {SPECL [...]} \
                                {UNDISCH ...} \
                        ] "Common Rules (1)" "A list of commonly used rules, which the user may specify."\
                    ] \
                    [list TkGoalProof_flags(rules2,title) rules2Title \
                        STRING "General Rules" "Common Rules (2) Title" \
                        "The title of the first list of commonly used rules." \
                    ] \
                    [list TkGoalProof_flags(rules2) rules2 \
                        LIST "Common Rules (2)" "A list of commonly accessed rules, which the user may specify. If the list is empty it will not appear in various tools." \
                    ] \
                ]
             
        }

}



