#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------






#----------------------------------------------------------------------------
#
# WIDGET CLASS TkDefineType
#
# CONFIGURATION OPTIONS
#
# COMMANDS
#
#----------------------------------------------------------------------------


option add *TkDefineType.initial "" widgetDefault

proc TkDefineType { w args } {
        global gui_flags 
        global TkDefineType_flags
        global feedback
        global vals

        for {set i 0} {$i<[llength $args]} {incr i} {
            case [lindex $args $i] -initial {
                incr i
                set initial [lindex $args $i]
            } default {
                error "unrecognized arg [lindex $args $i]"
            }
        }

        global busy
        incr busy
        toplevel $w -class TkDefineType
        if ![info exists initial] { set initial [option get $w initial Initial] }


        wm withdraw $w
        wm title $w "New Type Definition"
        
        set feedback [list {} "Creating TkDefineType display..."]
        
        
            #---------------
        frame $w.sources
        pack $w.sources -side top -fill both -expand yes -padx 5 -pady 5
        
        pack [frame $w.typespec] -in $w.sources -side top -fill both -expand yes
        pack [fontcheck label $w.typespec.lab -font $gui_flags(font,labels) -text "Type Specification:" -anchor w] -side top -fill x
        pack [fontcheck scrollable text $w.typespec.spec \
                -relief sunken \
                -font $gui_flags(font,codeentry) \
                -borderwidth 2 \
                -height 10 \
                -width 50 \
        ] -fill both -expand yes

        pack [frame $w.options]
        
        pack [frame $w.options.basic -borderwidth 2 -relief sunken] -fill both -expand yes -padx 5 -pady 5 -side left
        pack [label $w.options.basic.label -text "Basic Options:" -anchor w -font $gui_flags(font,labels)] -side top -fill x
        foreach buttondef [list \
                [list define_type "Define Type"] \
                [list prove_induct "Prove Induction Theorem"] \
                [list prove_oneone "Prove Constructors 1-1"] \
                [list prove_distinct "Prove Constructors Distinct"] \
                [list prove_reversed_distinct "Prove Reversed Distinction Theorems also"] \
                [list prove_cases "Prove Cases Theorem"] \
            ] {
            pack [fontcheck focusable checkbutton $w.options.basic.[lindex $buttondef 0]\
                -variable vals($w,[lindex $buttondef 0]) \
                -text [lindex $buttondef 1] \
                -relief flat \
                -anchor w \
                -font $gui_flags(font,buttons)] \
            -side top -fill x -padx 10
            set vals($w,[lindex $buttondef 0]) 1
        }
        pack [frame $w.options.additional -borderwidth 2 -relief sunken] -side top -fill both -expand yes -padx 5 -pady 5 -side right
        pack [label $w.options.additional.label -text "Additional Options (not yet available):" -anchor w -font $gui_flags(font,labels)] -side top -fill x
        foreach buttondef [list \
                [list define_discriminators "Define selectors on variants"] \
                [list define_accessors "Define accessors on records"] \
                [list define_mutators "Define mutators on records"] \
                [list prove_mutators_commute "Prove mutators commute"] \
                [list define_ml_functions "Define ML syntax functions"] \
            ] {
            pack [fontcheck focusable checkbutton $w.options.additional.[lindex $buttondef 0]\
                    -variable vals($w,[lindex $buttondef 0]) \
                    -text [lindex $buttondef 1] \
                    -relief flat \
                    -anchor w \
                    -font $gui_flags(font,buttons)] \
                -side top -fill x -padx 10
            $w.options.additional.[lindex $buttondef 0].b config -state disabled 
            set vals($w,[lindex $buttondef 0]) 0
        }
        pack [frame $w.options.save -borderwidth 2 -relief sunken] -side bottom -fill x -padx 5 -pady 5

#       pack [label $w.options.save.label -text "Save Options:" -anchor w -font $gui_flags(font,labels)] -side top -fill x
#       foreach buttondef [list \
#               [list save_thms "Save Theorems"] \
#               [list view_thms "View Script"] \
#           ] {
#           pack [fontcheck focusable checkbutton $w.options.save.[lindex $buttondef 0]\
#               -variable vals($w,[lindex $buttondef 0]) \
#               -text [lindex $buttondef 1] \
#               -relief flat \
#               -anchor w \
#               -font $gui_flags(font,buttons)] \
#           -side top -fill x -padx 10
#           set vals($w,[lindex $buttondef 0]) 1
#       }
        set vals($w,save_thms) 1
        set vals($w,view_thms) 1


        pack [frame $w.controls -borderwidth 2]
        pack [fontcheck focusable button $w.controls.define \
                -command "TkDefineType::define $w" \
                -text "Execute" \
                -width 11 \
                -font $gui_flags(font,buttons)] \
            -side left -fill x -padx 5 -pady 10

        set helpcommand "Help::tutorial TkDefineType"
        pack [fontcheck focusable button $w.controls.help \
                -command $helpcommand \
                -text "Help" \
                -width 11 \
                -font $gui_flags(font,buttons)] \
            -side left -fill x -padx 5 -pady 10
        pack [fontcheck focusable button $w.controls.close \
                -command "destroy $w" \
                -text "Close" \
                -width 11 \
                -font $gui_flags(font,buttons)] \
            -side left -fill x -padx 5 -pady 10
        

        if {$initial == ""} {
            $w.typespec.spec.b insert 1.0 "btree = LEAF of 'tag\n      | NODE of  btree => btree"
        } else {
            TkDefineType::reload $w $initial
        }


        bind $w <Destroy> "unset_vals_for_widget $w"

        update
        wm deiconify $w
        tkwait visibility $w
        update
        focus_goToFirst $w.typespec
        button_setDefault $w.controls.define
        update


        incr busy -1
        return $w
}


proc TkDefineType::reload { w argscode } {
        global vals
        global busy
        incr busy
        set name [ML "SmlToStrings.exp_to_string (ScriptFragments.arg_to_exp (el 1 \n$argscode\n))"]
        set vals($w,fixities) [ML "SmlToStrings.exp_to_string (ScriptFragments.arg_to_exp (el 2 \n$argscode\n))"]
        set vals($w,type_spec) [ML "SmlToStrings.exp_to_string (ScriptFragments.arg_to_exp (el 3 \n$argscode\n))"]
        set proofcode "ScriptFragments.arg_to_bwdproof (el 3 \n$argscode\n)"
        wm title $w "DefineType: $name"
        $w.typespec.spec text delete 1.0 end
        $w.typespec.spec text insert insert [ml_dequote $vals($w,type_spec)]

        incr busy -1
}

#----------------------------------------------------------------------------
# TkDefineType::define
#
#----------------------------------------------------------------------------

proc TkDefineType::define { w  } {
        global TkHol_flags
        global feedback
        global gui_flags
        global vals
        set spec [string trim [$w.typespec.spec.b get 1.0 end]]
        scan $spec %s typename
        set axiom_name [set typename]_Axiom
        set induct_name [set typename]_Induct
        set oneone_name [set typename]_11
        set distinct_name [set typename]_distinct
        set cases_name [set typename]_cases

        if $vals($w,define_type) {
        # Now proceed to the fixities, which are needed for HOL90 only.
            if [hol90] {
                set mlcode "map (#constructor) (#clauses (Parse.type_spec_parser ([ml_frag_quote $spec])))"
                if [catch {ML -type stringlist -check 1 $mlcode} constructors] {
                    errormessage $w.error $constructors; return
                }
                modalDialog transient specifyfixities $w.fixities \
                        -header "Select the fixities for the constructors:" \
                        -resultsvariable vals($w,waiter) \
                        -constructors $constructors \
                        -withfeedback 0
                widget_waitVariable vals($w,waiter)
                modalDialog.end $w.fixities
                switch -- [lindex $vals($w,waiter) 0] Ok { 
                    set fixities [lrange $vals($w,waiter) 1 end]
                } Cancel { 
                    return
                }
            }
            set feedback [list $w "Defining the type..."]

            if [hol88] {
                set defn "define_type \n    [ml_string $axiom_name] \n[ml_string $spec]"
            }
            if [hol90] {
                set defn "define_type {\n    fixities=[ml_list $fixities], \n    name=[ml_string $axiom_name], \n    type_spec=\n[ml_frag_quote $spec]\n}"
            }
            set script "[ml_val] $axiom_name = [join [split $defn \n] "\n    "][ml_end_dec]"
            lappend sections [list $axiom_name $defn $script]
        }

        if $vals($w,prove_induct) {
            set defn "[hol_prove_induction_thm] $axiom_name"
            if $vals($w,save_thms) {
                set defn "save_thm([ml_string $induct_name], \n        $defn)"  
            }
            set script "[ml_val] $induct_name = [join [split $defn \n] "\n    "][ml_end_dec]"
            lappend sections [list $induct_name $defn $script]
        }

        if $vals($w,prove_oneone) {
            set defn "[hol_prove_constructors_one_one] $axiom_name"
            if $vals($w,save_thms) {
                set defn "save_thm([ml_string $oneone_name], \n    $defn)"      
            }
            set script "[ml_val] $oneone_name = [join [split $defn \n] "\n    "][ml_end_dec]"
            lappend sections [list $oneone_name $defn $script]
        }

        if $vals($w,prove_distinct) {
            if $vals($w,prove_reversed_distinct) {
                set defn "([ml_letval] thml = CONJUNCTS ([hol_prove_constructors_distinct] $axiom_name) \n[ml_letin] (LIST_CONJ (thml @ (map GSYM thml))) [ml_letend])"
            } else {
                set defn "[hol_prove_constructors_distinct] $axiom_name"
            }
            if $vals($w,save_thms) {
                set defn "save_thm([ml_string $distinct_name], \n[join [split $defn \n] "\n    "])"     
            }
            set script "[ml_val] $distinct_name = [join [split $defn \n] "\n    "][ml_end_dec]"
            lappend sections [list $distinct_name $defn $script]
        }

        if $vals($w,prove_cases) {
            set defn "[hol_prove_cases_thm] $induct_name"
            if $vals($w,save_thms) {
                set defn "save_thm([ml_string $cases_name], \n    $defn)"       
            }
            set script "[ml_val] $cases_name = [join [split $defn \n] "\n    "][ml_end_dec]"
            lappend sections [list $cases_name $defn $script]
        }


        global busy
        incr busy
        set total_script ""
        set objspecs ""
        foreach section $sections {
            set name [lindex $section 0]
            set defn [lindex $section 1]
            set script [lindex $section 2]
            set feedback [list $w "Proving/Defining $name"]
            if [catch {ML_bind -check 1 -log 0  $name $defn } err] {
                errormessage $w.error $err; incr busy -1; return
            }
            lappend objspecs [list $name [list THM [list CODE $name]]]
            ML -run 0 -toplevel 1 -log 1 $script
            set total_script "[set total_script]\n\n$script"
        }
                   
        if $TkHol_flags(managingScripts) {
            if {[choice $w.verify -text "\"$typename\" has been successfully defined.  Should $gui_flags(title) add this operation to [Scripts::current_script]?" -buttons [list Yes No]]=="Yes"} {
                Scripts::add_to_script $total_script
            }
        } else {
            set newwin [newwin TheoremsTopLevel \
                -title {TkDefineType Results} \
                -header {Theorems Generated by TkDefineType:} \
                -objspecs $objspecs \
                -mlbindbuttons 0 \
                -expandbuttons 1 \
                -withtext 1 \
                -text $total_script]
#           TheoremsFrame::expandall $newwin.objspecs
        }

        incr busy -1    
        if {[choice $w.verify -text "Define another recursive type?" -buttons [list Yes No]]=="No"} {
            destroy $w
        }

}



#----------------------------------------------------------------------------
#
#----------------------------------------------------------------------------

proc tkntd { } {
   after 1 {
        source $TkDefineType_library/src/TkDefineType.tcl
        newwin TkDefineType
   }
}

