#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




#----------------------------------------------------------------------------
#
# delayedLoad
#
# Load all the ML code to do rich text formatting.
#
# Set up the initial interface map.
#
#----------------------------------------------------------------------------

proc TheoremWidgets::delayedLoadNotify { } {
        global TheoremWidgets_flags 
        if {$TheoremWidgets_flags(notify_loaded)} { return }
        hol_load_library tcl_notify
        set TheoremWidgets_flags(notify_loaded) 1

}

proc TheoremWidgets::delayedLoadPlainText { } {
        global TheoremWidgets_flags 
        if {$TheoremWidgets_flags(plaintext_loaded)} { return }
        hol_load_library plaintext
        set TheoremWidgets_flags(plaintext_loaded) 1

}

proc TheoremWidgets::delayedLoadStructuredText { } {
        global TheoremWidgets_library 
        global TheoremWidgets_flags 

        global gui_flags
        global tksml_slave_flags
        global install_dir_tkhol
        global busy

        if $TheoremWidgets_flags(structuredtext_loaded) { return }
        incr busy
        if [hol90] {
            if ![ML -type bool "op_mem lib_eq (find_library [ml_string holpp_to_tcl]) (loaded_libraries())"] {
                set infowin [newwin toplevel]
                wm title $infowin "Helpful Hints"
                pack [focusable button $infowin.close \
                    -text "Close"  \
                    -command "destroy $infowin"  \
                    -font $gui_flags(font,buttons) \
                ] -side bottom
                pack [scrollable text $infowin.message \
                    -font $gui_flags(font,helptext) \
                    -relief sunken \
                    -borderwidth 2 \
                ] -expand yes -fill both
                $infowin.message text insert 1.0 "
A Helpful Hint
--------------

You  have  just  performed  an  operation  which  requires certain \
$gui_flags(title) specific, richtext producing libraries
to  be loaded. $gui_flags(title) is now \
loading  these  library.  The library is not being compiled, as \
this   tends   to   take   a   long   time,   but  this  means \
$gui_flags(title) will take longer to display text. 

If you plan to use $gui_flags(title) often, you should consider \
incorporating the \"holpp_to_tcl\" library into an HOL executable.  \
You can do this with the following commands:

        > $tksml_slave_flags(ml)
        - Globals.library_path := (!Globals.library_path)@
             \[[ml_string $install_dir_tkhol/hol90/mlpretty_runtime/],
               [ml_string $install_dir_tkhol/hol90/termpaths/],
               [ml_string $install_dir_tkhol/hol90/richtext/]\];
        - load_library_in_place (find_library [ml_string holpp_to_tcl]);
        - save_hol \"<your hol filename>\";
        - exit();
        >

Loading and compiling the library adds approximately 540KB to the size of \
you HOL image, although 240K of this is reused \
by other parts of $gui_flags(title).  \
Richtext printing becomes approximately 3 times \
faster.  Using a HOL image with the library loaded does not \
interfere with the normal operation of HOL when not using \
$gui_flags(title)."

                hol_load_library holpp_to_tcl
            }   
        
            RichText::installInterfaceMap BaseLogicTk $TheoremWidgets_flags(interface_map,BaseLogicTk)
            RichText::installInterfaceMap SetsTk $TheoremWidgets_flags(interface_map,SetsTk)
            RichText::installInterfaceMap RealsTk $TheoremWidgets_flags(interface_map,RealsTk)
            set TheoremWidgets_flags(structuredtext_loaded) 1
        }
        incr busy -1
}

