#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




proc richtextcontrols {} {}

composite_define RichTextControls {
        {-structuredtextvar structuredtextVar structuredtext composite_configPrivateNop}
        {-richtextvar richtextVar RichtextVar richtext composite_configPrivateNop}
        {-showtypesvar showtypesVar ShowtypesVar showtypes composite_configPrivateNop}
        {-editingvar editingVar EditingVar editing composite_configPrivateNop}
} RichTextControls::initProc

proc RichTextControls::initProc { w args } {
        upvar #0 config$w config
        upvar #0 $w data
        pack [fontcheck checkbutton $w.structuredtext \
            -text "Rich" \
            -font "-adobe-helvetica-medium-o-normal-*-*-80-*-*-*-*-*-*" \
            -variable $config(structuredtextVar) \
            -command "after 1 \{$w structuredtext_trigger\}" \
        ] -fill x
        pack [fontcheck checkbutton $w.richtext \
            -text "Fonts" \
            -font "-adobe-helvetica-medium-o-normal-*-*-80-*-*-*-*-*-*" \
            -variable $config(richtextVar) \
        ] -fill x
        pack [fontcheck checkbutton $w.showtypes \
            -text "Types" \
            -font "-adobe-helvetica-medium-o-normal-*-*-80-*-*-*-*-*-*" \
            -variable $config(showtypesVar) \
        ] -fill x
        set data(off) 0
        trace variable $config(editingVar) w "$w editing_trigger"
        return $w
}

composite_subcommand RichTextControls structuredtext_trigger { w args } {
        upvar #0 $w data
        upvar #0 config$w config
        upvar #0 $config(structuredtextVar) structuredtext
        
        if $structuredtext { 
              $w.richtext config -state normal -variable $config(richtextVar)
#              $w.showtypes config -state normal -variable $config(showtypesVar)
        } else { 
              $w.richtext config -state disabled -variable [set w](off)
#              $w.showtypes config -state disabled -variable [set w](off)
        }
}


composite_subcommand RichTextControls editing_trigger { w args } {
        upvar #0 $w data
        upvar #0 config$w config
        upvar #0 $config(editingvar) editing
        if $editing { 
            $w.richtext config -state disabled -variable [set w](off)
#            $w.showtypes config -state disabled -variable [set w](off)
            $w.structuredtext config -state disabled -variable [set w](off)
        } else { 
            $w.richtext config -state normal -variable $config(richtextvar)
#            $w.showtypes config -state normal -variable $config(showtypesvar)
            $w.structuredtext config -state normal -variable $config(structuredtextvar)
        }
}




