#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------





proc NewDef { w args } {
        global gui_flags 
        global NewDef_flags
        global feedback
        global busy
        incr busy
        global vals

        for {set i 0} {$i<[llength $args]} {incr i} {
            case [lindex $args $i] -initial {
                incr i
                set initial [lindex $args $i]
            } default {
                error "unrecognized arg [lindex $args $i]"
            }
        }

        toplevel $w -class NewDef

        wm withdraw $w
        wm title $w "New Constant Definition"
        
        set feedback [list {} "Creating NewDef display..."]
        

            #---------------

#       pack [collapsible frame $w.templ -title "Template:" -visible 1] \
#               -side top -fill both -padx 5 -pady 5
#       pack [fontcheck entry $w.templ.b.templ \
#               -font $gui_flags(font,codeentry) \
#               -width 30 \
#                -relief sunken \
#       ] -side top -fill x -expand yes
#       bind $w.templ.b.templ <Any-Return> "NewDef::remake_template_specification $w; ; [bind Text <Tab>]"
#       bind $w.templ.b.templ <Any-Tab> "NewDef::remake_template_specification $w; [bind Text <Tab>]"

        pack [frame $w.spec] -side top -fill both -expand yes -padx 5 -pady 5
        pack [label $w.spec.lab \
                -text "Full Specification:" \
                -font $gui_flags(font,labels) \
                -anchor w] -fill x

        pack [frame $w.controls -borderwidth 2] -pady 5
        pack [fontcheck focusable button $w.controls.define \
                -command "NewRecDef::define $w" \
                -text "Execute" \
                -width 7 \
                -font $gui_flags(font,buttons)] \
            -side left -fill x -padx 5

        set helpcommand "Help::tutorial NewDef"
        pack [fontcheck focusable button $w.controls.help \
                -command $helpcommand \
                -text "Help" \
                -width 7 \
                -font $gui_flags(font,buttons)] \
            -side left -fill x -padx 5
        pack [fontcheck focusable button $w.controls.close \
                -command "destroy $w" \
                -text "Close" \
                -width 7 \
                -font $gui_flags(font,buttons)] \
            -side left -fill x -padx 5
        
        pack [richtext $w.spec.spec \
                -richtextvar vals($w,richtext) \
                -showtypesvar vals($w,showtypes) \
                -structuredtextvar vals($w,structuredtext) \
                -editingvar vals($w,editing) \
        ] -expand yes -fill both
        $w.spec.spec text config -height 6 -width 80
        
        bind $w <Destroy> "unset_vals_for_widget $w"

#       $w.templ.b.templ insert 0 "NewConst arg1 arg2"
#       NewDef::remake_template_specification $w
        if ![info exists NewDef_flags(previous)] {
            set NewDef_flags(previous) "Delete this text and enter your definition here.\nFor example:\n   NewConst arg1 arg2 = arg1 + arg2"
        }
        if [info exists initial] {
            set def [ML "#def (ScriptFragments.data_for_new_definition ($initial))"]
            $w.spec.spec editpreterm [list TEXT [hol_determ $def]]
        } else {
            $w.spec.spec editpreterm [list TEXT $NewDef_flags(previous)]
        }
        button_setDefault $w.controls.define
        update
        wm deiconify $w
        tkwait visibility $w
        update
        focus_goToFirst [$w.spec.spec text]

        incr busy -1
        return $w
}


#proc NewDef::remake_template_specification { w } {
#       global gui_flags
#       set templ [$w.templ.b.templ get]
#       set oldspec [$w.spec.spec getpreterm]
#       set eqpos [string first = $oldspec]
#       if {$eqpos==-1} {
#           set oldrhs "= ..."
#       } else {
#           set oldrhs [string range $oldspec $eqpos end]
#       }
#       $w.spec.spec editpreterm [list TEXT "$templ $oldrhs"]
#}

#----------------------------------------------------------------------------
# NewDef::define
#
#----------------------------------------------------------------------------

proc NewDef::define { w  } {
        global gui_flags
        global NewDef_flags
        global TkHol_flags
        global feedback
        global busy
        global vals
        incr busy
        set spec [string trim [$w.spec.spec getpreterm]]
        set neat_spec [join [split $spec \n] "\n        "]
        if {![regexp  "^\[A-Za-z\]\[^\\(\\)\t \n\]*" $spec constname]} {
            errormessage $w.error "TkHol could not determine the name of the constant from the \
specification.  Only constants beginning with alphabet characters \
may be specified using this tool.  The name should also be the first \
word to appear in the specification."
            incr busy -1
            return 
        }
        set thm_name [set constname]_DEF
        set sections ""
        # Now proceed to the fixities, which are needed for HOL90 only.
            set defn "new_definition([ml_string $thm_name],[hol_term $neat_spec])"
            set script "[ml_val] $thm_name = $defn[ml_end_dec]"
            lappend sections [list $thm_name $defn $script]

        set total_script ""
        set thmspecs ""
        foreach section $sections {
            set name [lindex $section 0]
            set defn [lindex $section 1]
            set script [lindex $section 2]
            set feedback [list $w "Defining $name"]
            if [catch {ML_bind -check 1 -log 0 $name $defn} err] {
                errormessage $w.error $err; incr busy -1; return
            }
            lappend thmspecs [list $name [list THM [list CODE $name]]]
            ML -run 0 -toplevel 1 -log 1 $script
            set total_script "[set total_script]$script"
        }
                   
        if $TkHol_flags(managingScripts) {
            if {[choice $w.verify -text "\"$constname\" has been successfully defined.  Should $gui_flags(title) add this operation to [Scripts::current_script]?" -buttons [list Yes No]]=="Yes"} {
                Scripts::add_to_script $script
            }
        } else {
            set newwin [newwin TheoremsTopLevel \
                -title {NewDef Results} \
                -header {Theorem Generated by NewDef:} \
                -objspecs $thmspecs \
                -mlbindbuttons 0 \
                -expandbuttons 0 \
                -withtext 1 \
                -text $total_script]
            $newwin.objs expandall

        }
        set NewDef_flags(previous) $spec
        incr busy -1    
        if {[choice $w.verify -text "Make another simple definition?" -buttons [list Yes No]]=="No"} {
            destroy $w
        }

}



#----------------------------------------------------------------------------
#
#----------------------------------------------------------------------------

proc tkntd { } {
   after 1 {
        source $NewDef_library/src/NewDef.tcl
        newwin NewDef
   }
}
