#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------





proc HolHelp::ProcessArgs { argc argv } {
        global gui_flags
        global Help_flags

        if {[llength [info commands Preferences_Add]]==1} {
            Preferences_Add "WWW Browser" "Options related to running your WWW Browser are specified here." \
                [list \
                    [list Help_flags(wwwBrowser) wwwBrowser STRING "Mosaic" "WWW Browser" "This is the WWW (World Wide Web) browser that $gui_flags(title) uses to display the HOL help pages.  The URL of the page to be displayed is appended to the given command before execution."] \
                    [list Help_flags(cooptMosaic) cooptMosaic BOOL 1 "Co-opt an Existing Browser" "If this is on then TkHolWorkbench will make use of a running Mosaic or Netscape session when a help page is requested, instead of spawning a new browser."] \
                    [list Help_flags(psCommand) psCommand STRING "/bin/ps -x" "Process Lookup Command" "This command is needed to control Mosaic by remote control.  If you are not using Mosaic you may ignore this option.  The default value will nearly always be correct."] \
                    [list Help_flags(killCommand) killCommand STRING "/bin/kill" "Process Signal Sender" "This command is needed to control Mosaic by remote control.  If you are not using Mosaic you may ignore this option.  The default value will nearly always be correct."] \
                    [list Help_flags(lal_URL) lalURL STRING "http://lal.cs.byu.edu/lal/hol-documentation.html" "LAL HOL Documentation Root" "This is the root of the WWW location where the Brigham Young University's LAL HOL Documentation can be found.  Some sites, such as the University of Cambridge, have their own local copy of this documentation.  Other sites from the one at BYU (http://lal.cs.byu.edu/lal/hol-documentation.html) include:\n\thttp://www.cl.cam.ac.uk/lal_holdoc/hol-documentation.html\n"] \
                    [list Help_flags(hol90_URL) hol90URL STRING "" "hol90 Documentation URL" "This is the root of the WWW location where the HOL90 documentation resides.  This is usually local to your system and available under your hol90 documentation directory.  If this value is empty then it will be set the first time you reconfigure $gui_flags(title) with hol90 installed."] \
             ]
        }
}





