(* name.ml                                               (c) R.J.Boulton 1990 *)
(*----------------------------------------------------------------------------*)


signature TRS_name_sig = 
sig
	datatype wildchar = WILDCHAR of string;

	val show_wildchar : wildchar -> string

	exception BAD_WILDCHAR;
	val make_wildchar : string -> wildchar
	exception WILDCHARS_NOT_DIFFERENT;
	type namepattern;
	val show_namepattern : namepattern -> string * wildchar * wildchar
   	val make_namepattern : string * wildchar * wildchar -> namepattern
	val show_full_namepattern : namepattern -> string * string * string
 	val make_full_namepattern : string * string * string -> namepattern
	val autonamepattern : string -> namepattern
	val namematch : namepattern -> string -> bool

end;

