
#----------------------------------------------------------------------------
#
# delayedLoad
#
# Load all the ML code to do rich text formatting.
#
# Set up the initial interface map.
#
#----------------------------------------------------------------------------

proc ProofsPP::delayedLoadNotify { } {
        global ProofsPP_flags 
        if {$ProofsPP_flags(notify_loaded)} { return }
        if [hol90] {
            ML -toplevel 1 " \n \
                prim_load_library Lib.interpret \{lib=find_library [ml_string tcl_notify],theory=\"-\"\}; \n \
            "
        }
        set ProofsPP_flags(notify_loaded) 1

}

proc ProofsPP::delayedLoadPlainText { } {
#       global ProofsPP_flags 
#       if {$ProofsPP_flags(plaintext_loaded)} { return }
#       hol_load_library plaintext
#       set ProofsPP_flags(plaintext_loaded) 1

}

proc ProofsPP::delayedLoadStructuredText { } {
        global ProofsPP_library 
        global ProofsPP_flags 

        global gui_flags
        global tksml_slave_flags
        global install_dir_tkhol

        if $ProofsPP_flags(structuredtext_loaded) { return }
        if [hol90] {
            if [ML -type bool "not (exists (fn x => lib_eq x (find_library [ml_string replay])) (loaded_libraries()))"] {
                set infowin [newwin toplevel]
                wm title $infowin "Helpful Hints"
                pack [focusable button $infowin.close \
                    -text "Close"  \
                    -command "destroy $infowin"  \
                    -font $gui_flags(font,buttons) \
                ] -side bottom
                pack [scrollable text $infowin.message \
                    -font $gui_flags(font,helptext) \
                    -relief sunken \
                    -borderwidth 2 \
                ] -expand yes -fill both
                $infowin.message text insert 1.0 "
A Helpful Hint
--------------

You  have  just  performed  an  operation  which  requires the \
\"replay\"  library  to  be loaded. $gui_flags(title) is now \
loading  this  library.  The library is not being compiled, as \
this   tends   to   take   a   long   time,   but  this  means \
$gui_flags(title) will take longer to display text. 

If you plan to use $gui_flags(title) often, you should consider \
incorporating the \"holpp_to_tcl\" library into an HOL executable.  \
You can do this with the following commands:

        > $tksml_slave_flags(ml)
        - Globals.library_path := (!Globals.library_path)@
             \[[ml_string $install_dir_tkhol/hol90/mlpretty_runtime/],
               [ml_string $install_dir_tkhol/hol90/replay/]\];
        - load_library_in_place (find_library [ml_string replay]);
        - save_hol \"<your hol filename>\";
        - exit();
        >

Loading and compiling the library adds approximately 300KB to the size of \
you HOL image, although 240K of this is reused \
by other parts of $gui_flags(title).  \
Proof display becomes approximately 3 times \
faster.  Using a HOL image with the library loaded does not \
interfere with the normal operation of HOL when not using \
$gui_flags(title)."

                hol_load_library holpp_to_tcl
            }   
        
            RichText::installInterfaceMap ProofsTk $ProofsPP_flags(interface_map,ProofsTk)
            set ProofsPP_flags(structuredtext_loaded) 1
        }
}



