(****************************************************************************)
(*                                                                          *)
(*               Copyright 1994, 1995 University of Cambridge               *)
(*                                                                          *)
(*                           All rights reserved.                           *)
(*                                                                          *)
(****************************************************************************)

(****************************************************************************)
(* FILE          : portable.sig                                             *)
(* DESCRIPTION   : Signature for general purpose functions.                 *)
(*                                                                          *)
(* AUTHOR        : R.J.Boulton                                              *)
(* DATE          : 29th November 1994                                       *)
(*                                                                          *)
(* LAST MODIFIED : R.J.Boulton                                              *)
(* DATE          : 28th February 1995                                       *)
(****************************************************************************)

signature PORTABLE =
sig

   val chr : int -> string
   val ord : string -> int
   val explode : string -> string list
   val implode : string list -> string

   datatype 'a option = NONE | SOME of 'a
   exception Fail of string

   val can : ('a -> 'b) -> 'a -> bool
   val cannot : ('a -> 'b) -> 'a -> bool
   val funpow : ('a -> 'a) -> int -> 'a -> 'a

   exception Hd
   val hd : 'a list -> 'a
   exception Tl
   val tl : 'a list -> 'a list
   val null : 'a list -> bool
   val length : 'a list -> int
   val flat : 'a list list -> 'a list

   val fold : ('a * 'b -> 'b) -> 'a list -> 'b -> 'b
   val revfold : ('a * 'b -> 'b) -> 'a list -> 'b -> 'b

   exception Nth
   val nth : 'a list * int -> 'a
   exception NthHead
   val nthhead : 'a list * int -> 'a list
   exception NthTail
   val nthtail : 'a list * int -> 'a list
   val last : 'a list -> 'a
   val rotate : int -> 'a list -> 'a list

   val exists : ('a -> bool) -> 'a list -> bool
   val forall : ('a -> bool) -> 'a list -> bool
   val filter : ('a -> bool) -> 'a list -> 'a list

   exception Find
   val find : ('a -> bool) -> 'a list -> 'a
   exception NOT_FOUND
   val assoc : ''a -> (''a * 'b) list -> 'b
   val rev_assoc : ''a -> ('b * ''a) list -> 'b

   val zip : 'a list * 'b list -> ('a * 'b) list
   val unzip : ('a * 'b) list -> 'a list * 'b list

   val member_component : ('a -> ''b) -> ''b -> 'a list -> bool
   val member : ''a -> ''a list -> bool
   val intersect : ''a list -> ''a list -> ''a list
   val subtract : ''a list -> ''a list -> ''a list
   val union : ''a list -> ''a list -> ''a list
   val set_equal : ''a list -> ''a list -> bool
   val remove_duplicates : ('a * 'a -> bool) -> 'a list -> 'a list
   val setify : ''a list -> ''a list

   val mapcan : ('a -> 'b) -> 'a list -> 'b list
   val duplicate_components : ('a -> ''b) -> 'a list -> 'a list
   val duplicates : ''a list -> ''a list
   val split_at : ''a -> ''a list -> ''a list * ''a list
   val upto : int -> int -> int list
   val map_thread : ('a * 'b -> 'c * 'b) -> 'a list * 'b -> 'c list * 'b
   val flat_map_thread
          : ('a * 'b -> 'c list * 'b) -> 'a list * 'b -> 'c list * 'b
   val initial_length : ('a -> bool) -> 'a list -> int
   val common_head : ''a list * ''a list -> ''a list * (''a list * ''a list)
   val is_subsequence : ''a list -> ''a list -> bool
   val pairings : ('a * 'b -> 'c) -> 'a list * 'b list -> 'c list
   val replace_or_add
          : ('a -> 'a -> 'a) -> ('a -> ''b) -> 'a list -> 'a list -> 'a list

   val string_of_int : int -> string
   exception IntOfString
   val int_of_string : string -> int
   exception Substring
   val substring : string * int * int -> string
   val ordof : string * int -> int

   val min : int * int -> int
   val max : int * int -> int

   val inc : int ref -> unit
   val dec : int ref -> unit

end;
