
#############################################################################
#   tksml.tcl,v 1.6 1995/09/01 01:24:14 drs1004 Exp
#    Copyright (C) 1994  Donald Syme
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 1, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    Contact Details:
#	Donald Syme
#	The Computer Laboratory
#	New Musuems Site
#	Pembroke St.
#	Cambridge U.K. CB2 3QG
#
#	email: Donald.Syme@cl.cam.ac.uk
#
#############################################################################

#----------------------------------------------------------------------------
#
# load_package
#
#
#----------------------------------------------------------------------------

#
# Run auto_index in the package directories
# if necessary or requested.
#
proc load_package_part1 { packagedir mkindex } {
    if {($mkindex || ![file exists $packagedir/src/tclIndex]) && ![catch {glob $packagedir/src/*.tcl}]} {
        puts "Making tclIndex for $packagedir..."
	auto_mkindex $packagedir/src *.tcl
    }			    
}

proc load_package_part2 { packagedir } {
    global version patchlevel auto_path
    # find the last word in the package directory path, i.e.
    # the package name
    if {[string index $packagedir [expr [string length $packagedir]-1]]=="/"} {
        set packagedir [string range $packagedir 0 [expr [string length $packagedir]-2]]
    }
    set packagename [string range $packagedir [expr [string last / $packagedir]+1] end]
    lappend auto_path $packagedir/src
    global [set packagename]_library
    global [set packagename]_flags
    set [set packagename]_library $packagedir
    set [set packagename]_flags(version) $version
    set [set packagename]_flags(patchlevel) $patchlevel
    return $packagename
}

proc load_package_part3 { package argc argv } { 
    global feedback
    catch {auto_load [set package]::ProcessArgs}
    if [llength [info commands [set package]::ProcessArgs]]==1 {
        set feedback [list {} "Loading package $package"]
        [set package]::ProcessArgs $argc $argv
    }
}


proc load_package_part4 { package } {
    global gui_flags
    # puts "load_package_part4, package = $package"
    catch {auto_load [set package]::InitialisePackage}
    if [llength [info commands [set package]::InitialisePackage]]==1 {
        set feedback [list {} "Initialising package $package"]
        [set package]::InitialisePackage
    }
    lappend gui_flags(loaded_packages) $package
}

proc load_package { packagedir } {
    load_package_part1 $packagedir 0
    set package [load_package_part2 $packagedir]
    load_package_part3 $package 0 {}
    load_package_part4 $package
}

proc unload_package { package } {
    catch {auto_load [set package]::ShutdownPackage}
    if {[llength [info commands [set package]::ShutdownPackage]] == 1} {
         [set package]::ShutdownPackage
    }
}
proc newwin {type args } {
	global newwin_priv
	global gui_flags
	set passon_args ""
	set withfeedback 1
	set minsize "1 1"
        for {set i 0} {$i < [llength $args]} {incr i} {
            global gui_flags
	    set arg [lindex $args $i]
            switch -- $arg -title {
               incr i
               set title [lindex $args $i]
            } -withfeedback {
               incr i
               set withfeedback [lindex $args $i]
            } -minsize {
               incr i
               set minsize [lindex $args $i]
            } default {
               lappend passon_args $arg
            }
        }
	if ![info exists newwin_priv] { set newwin_priv 1 }
	set w .topwin[set newwin_priv]
	incr newwin_priv

	eval [list $type $w] $passon_args
	if ![winfo exists $w] { return }
	if [info exists title] { wm title $w $title }
	if [info exists minsize] { eval wm minsize $w $minsize }
	if {[info exists withfeedback] && $withfeedback} { 
	    if {$withfeedback} {
	        fontcheck label $w.feedback \
		    -height 1 \
	        	-width 40 \
	        	-anchor w \
	        	-relief sunken \
	        	-font $gui_flags(font,feedback)
	        pack $w.feedback -side bottom -expand no -fill x
            }
        }
	return $w
}

proc psource { package filebase } {
    	global [set package]_library
	exec sh << "(cd [set [set package]_library]/src; make $filebase.tcl)" >&@ stdout
	source [set [set package]_library]/src/$filebase.tcl
}

#----------------------------------------------------------------------------
#
# Starts and shutdowns packages.
#
#
#----------------------------------------------------------------------------

set gui_flags(debug) 0
set gui_flags(title) "No Title"
set mkindex 0
set top_wins ""
set packagedirs ""
for {set arg 0} {$arg < $argc} {incr arg} {
    global gui_flags
    switch -- [lindex $argv $arg] -configfile {
        incr arg
        set configfile [lindex $argv $arg]
    } 
}

if [info exists configfile] {
    source $configfile
}
source $install_dir_tksml/version.tcl
source $install_dir_tksml/patchlevel.tcl

for {set arg 0} {$arg < $argc} {incr arg} {
    global gui_flags
    switch -- [lindex $argv $arg] -arch {
	incr arg
        set gui_flags(arch) [lindex $argv $arg] 
    } -mkindex {
        set mkindex 1 
    } -nomkindex {
        set mkindex 0 
    } -debug {
        set gui_flags(debug) 1 
    } -win {
	incr arg
        lappend top_wins [lindex $argv $arg] 
    } -stopwin {
	incr arg
	set newtop_wins ""
	foreach top_win $top_wins {
	    if {[string first [lindex $argv $arg] $top_win]==-1} {
		lappend newtop_wins $top_win
	    }
	}
	set top_wins $newtop_wins
    } -package {
	incr arg
	lappend packagedirs [lindex $argv $arg]
    } -stoppackage {
	incr arg
	set newdirs ""
	foreach dir $packagedirs {
	    if {[string first [lindex $argv $arg] $dir]==-1} {
		lappend newdirs $dir
	    }
	}
	set packagedirs $newdirs
    } -title {
	incr arg
        set gui_flags(title) [lindex $argv $arg] 
    }
}

if ![info exists gui_flags(arch)] {
    if {[catch {set gui_flags(arch) [exec arch]}]} {
	puts stderr ""
        puts stderr "Hmmm... $gui_flags(title) could not execute arch - use a -arch <...> "
	puts stderr "        flag to specify your architecture."
	puts stderr ""
        exit
    }
}




foreach packagedir $packagedirs {
    load_package_part1 $packagedir $mkindex
}

if {$mkindex} exit

foreach packagedir $packagedirs {
    lappend packages [load_package_part2 $packagedir]
}	   


#
# 3. Initialise each package in the order they were found on the
# command line.
#
# We put a tiny delay (1 millisecond) in before creating the top 
# windows.  THIS IS FOR DEBUGGING PURPOSES, since tcl doesn't
# give proper stack dumps to errors during startup.  It does for
# scripts executed from timer signals and events (i.e. errors
# in the normal course of events)
#

wm withdraw .
after 1 {
	wm title . $gui_flags(title)
	set raised_busy 0
	foreach package $packages {
	    if {[info exists busy] && !$raised_busy} {
	        incr busy
		set raised_busy 1
	    } 
	    load_package_part3 $package $argc $argv
	}

	foreach package $packages {
	    load_package_part4 $package
	}

	set feedback [list {} "Creating top window(s)..."]
	foreach top_win $top_wins {
	    catch {auto_load $top_win}
    	    if [llength [info commands $top_win]]==1 {
	        newwin $top_win
	    }
	} 

	if {$raised_busy} {
	    incr busy -1
	}

	bind . <Destroy> {
		if $gui_flags(debug) { puts "In <Destroy> handler" }
	        global gui_flags(loaded_packages)
	        set rev_packages ""
	        foreach package $gui_flags(loaded_packages) {
	    	    set rev_packages [linsert $rev_packages 0 $package]
	        }
                foreach package $rev_packages {
		    if $gui_flags(debug) { puts "In <Destroy> handler, unloading $package" }
	            unload_package $package
	        }
		if $gui_flags(debug) { puts "Leaving <Destroy> handler" }
	}
	set feedback [list {} ""]
        tksml_slave::establish_stdin_processor
}



