(%--------------------------------------------------------------------------%)
(%                  Copyright (c) Donald Syme 1992                          %)
(%                  All rights reserved                                     %)
(%                                                                          %)
(% Donald Syme, hereafter referred to as `the Author', retains the copyright%)
(% and all other legal rights to the Software contained in this file,       %)
(% hereafter referred to as `the Software'.                                 %)
(%                                                                          %)
(% The Software is made available free of charge on an `as is' basis. No    %)
(% guarantee, either express or implied, of maintenance, reliability,       %)
(% merchantability or suitability for any purpose is made by the Author.    %)
(%                                                                          %)
(% The user is granted the right to make personal or internal use of the    %)
(% Software provided that both:                                             %)
(% 1. The Software is not used for commercial gain.                         %)
(% 2. The user shall not hold the Author liable for any consequences        %)
(%    arising from use of the Software.                                     %)
(%                                                                          %)
(% The user is granted the right to further distribute the Software         %)
(% provided that both:                                                      %)
(% 1. The Software and this statement of rights are not modified.           %)
(% 2. The Software does not form part or the whole of a system distributed  %)
(%    for commercial gain.                                                  %)
(%                                                                          %)
(% The user is granted the right to modify the Software for personal or     %)
(% internal use provided that all of the following conditions are observed: %)
(% 1. The user does not distribute the modified software.                   %)
(% 2. The modified software is not used for commercial gain.                %)
(% 3. The Author retains all rights to the modified software.               %)
(%                                                                          %)
(% Anyone seeking a licence to use this software for commercial purposes is %)
(% invited to contact the Author.                                           %)
(%--------------------------------------------------------------------------%)




type theory_tcl_client_notification_selection = 
                on_new_thm | 
                on_new_definition | 
                on_new_axiom | 
                on_new_constant |
                on_new_type;;

lettype theory_tcl_client = (string # string # (theory_tcl_client_notification_selection) list);;

letrec theory_add_tcl_client theory (tclclass,tclobj,selection) =
        theory_add_client theory (
           (tclclass ^ tclobj),
           (if (mem on_new_thm selection) 
               then (\thr. \thmname. \thm. tcl (tclclass ^ `::new_thm_Notify `  ^ tclobj ^ ` ` ^ thr ^ ` ` ^ thmname))
               else (\thr. \thmname. \thm. ())),
           (if (mem on_new_definition selection) 
               then (\thr. \thmname. \thm. tcl (tclclass ^ `::new_definition_Notify `  ^ tclobj ^ ` ` ^ thr ^ ` ` ^ thmname))
               else (\thr. \thmname. \thm. ())),
           (if (mem on_new_axiom selection) 
               then (\thr. \thmname. \thm. tcl (tclclass ^ `::new_axiom_Notify `  ^ tclobj ^ ` ` ^ thr ^ ` ` ^ thmname))
               else (\thr. \thmname. \thm. ())),
           (if (mem on_new_constant selection) 
               then (\thr. \const. tcl (tclclass ^ `::new_const_Notify `  ^ tclobj ^ ` ` ^ thr ^ ` ` ^ (fst (dest_const const))))
               else (\thr. \const. ())),
           (if (mem on_new_type selection) 
               then (\thr. \newtype. tcl (tclclass ^ `::new_type_Notify `  ^ tclobj ^ ` ` ^ thr ^ ` ` ^ (snd newtype)))
               else (\thr. \newtype. ()))
        );;


letrec theory_remove_tcl_client theory ((tclclass,tclobj,selection):theory_tcl_client) =
        theory_remove_client theory (tclclass ^ tclobj);;

