(%--------------------------------------------------------------------------%)
(%                  Copyright (c) Donald Syme 1992                          %)
(%                  All rights reserved                                     %)
(%                                                                          %)
(% Donald Syme, hereafter referred to as `the Author', retains the copyright%)
(% and all other legal rights to the Software contained in this file,       %)
(% hereafter referred to as `the Software'.                                 %)
(%                                                                          %)
(% The Software is made available free of charge on an `as is' basis. No    %)
(% guarantee, either express or implied, of maintenance, reliability,       %)
(% merchantability or suitability for any purpose is made by the Author.    %)
(%                                                                          %)
(% The user is granted the right to make personal or internal use of the    %)
(% Software provided that both:                                             %)
(% 1. The Software is not used for commercial gain.                         %)
(% 2. The user shall not hold the Author liable for any consequences        %)
(%    arising from use of the Software.                                     %)
(%                                                                          %)
(% The user is granted the right to further distribute the Software         %)
(% provided that both:                                                      %)
(% 1. The Software and this statement of rights are not modified.           %)
(% 2. The Software does not form part or the whole of a system distributed  %)
(%    for commercial gain.                                                  %)
(%                                                                          %)
(% The user is granted the right to modify the Software for personal or     %)
(% internal use provided that all of the following conditions are observed: %)
(% 1. The user does not distribute the modified software.                   %)
(% 2. The modified software is not used for commercial gain.                %)
(% 3. The Author retains all rights to the modified software.               %)
(%                                                                          %)
(% Anyone seeking a licence to use this software for commercial purposes is %)
(% invited to contact the Author.                                           %)
(%--------------------------------------------------------------------------%)



lettype current_theory_client = 
                string # 
                (string -> void) #      %< called when chrrent theory change >%
                (string -> void) #      %< called when new parent added to current theory >%
                (bool -> void);;        %< called when current theory mode change >%

letref current_theory_notification_list = []: current_theory_client list;; 

letrec current_theory_add_client client =
        (current_theory_notification_list := 
                (append [client] (current_theory_notification_list));
        ());;

letrec current_theory_remove_client clientname =
        (current_theory_notification_list := 
            filter (\(cl,_,_,_). not(cl = clientname)) (current_theory_notification_list);
        ());;

letrec load_theory_and_notify th =
        (load_theory_safe th;
        map (\ (_,client,_,_). client (current_theory())) (current_theory_notification_list); 
        ());;

letrec new_theory_and_notify th =
        (new_theory_safe th;
        map (\ (_,client,_,_). client (current_theory())) (current_theory_notification_list); 
        ());;

letrec extend_theory_and_notify th =
        (if (th = current_theory()) then
             (extend_theory_safe th;
             map (\ (_,_,_,client). client (draft_mode())) (current_theory_notification_list))
         else
             (extend_theory_safe th;
             map (\ (_,client,_,_). client (current_theory())) (current_theory_notification_list)); 
         ());;

letrec close_theory_and_notify th =
        (close_theory_safe th;
        map (\(_,_,_,client). client (draft_mode())) (current_theory_notification_list); 
        ());;


letrec new_parent_and_notify th =
         (new_parent_safe th;
           map (\(_,_,client,_). client (current_theory())) (current_theory_notification_list); 
         ());;
         
letrec load_library_and_notify th =                                 
        let old_parents = parents `-`
        and old_current = current_theory() in                   
        (load_library_safe th;
         if (not (old_current = current_theory())) then
                (map (\(_,x,_,_). x (current_theory()))
                (current_theory_notification_list);())
         else if (not (old_parents = parents `-`)) then
                (map (\(_,_,x,_). x (current_theory()))
                (current_theory_notification_list);())
         else ());;

let new_parent = new_parent_and_notify;;
let extend_theory = extend_theory_and_notify;;
let new_theory = new_theory_and_notify;;
let load_theory = load_theory_and_notify;;
let close_theory = close_theory_and_notify;;
let new_parent = new_parent_and_notify;;
let load_library = load_library_and_notify;;


