#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File: topLevelAux.tcl
#
# Description:
#       Procedures to handle keyboard traversal in top level windows
#
#       This file supports the `hybrid' focus model, in which top-level windows
#       follow the focus policy of the window manager (often
#       focus-follows-mouse), while non-toplevel widgets are click-to-focus
#       or keyboard-traversal.
#
#       It includes a handler for the <FocusIn> event for top-level windows.
#       If the event reports a `detail' field of `NotifyVirtual', then it
#       indicates that a window manager has directed the focus to the
#       top-level window, and the Tk focus is directed to the `current'
#       widget within that window.
#
# Global variables used:
#c      focus_priv(current,$w)
#               Most recently focused item among the children of toplevel
#               window $w.


# Procedure:    toplevel_focusIn
#
# Synopsis:
#       Handle the <FocusIn> event on top-level windows.
#
# Usage:
#c      toplevel_focusIn pathName detail
#
# Parameters:
#c      pathName
#               Path name of a toplevel widget (or the root window of the
#               application)
#c      detail
#               Detail field from a FocusIn event.
#
# Return value:
#       None.
#
# Description:
#       toplevel_focusIn is called to process <FocusIn> events on top-level
#       windows.  If the <FocusIn> event has a detail field of NotifyVirtual,
#       it indicates that focus has been directed to the given top-level
#       window by the window manager.  In this case, focus is directed to
#       the currently-focused component within the window.  Other detail
#       fields do nothing.
#
# Notes:
#       Focus is not redirected while a grab is active.
#
# Global variables used:
#c      focus_priv(current,$w)
#               Most recently focused item among the children of toplevel
#               window $w.

proc toplevel_focusIn {w detail} {
        global focus_priv
        if {$detail == "NotifyVirtual"} {
                if {[info exists focus_priv(current,$w)]} {
                        set f $focus_priv(current,$w)
                } else {
                        set f [focus:first $w]
                }
                if {$f == ""} {
                        return
                }
                set g [grab current $w]
                if {$g != ""} {
                        return
                }
                if {[lindex $f 0] == [focus]} {
                        if {[llength $f] <= 1} return
                        if {[lindex $f 1] == [[focus] focus]} return
                }
                after 1 "catch \"focus_goTo $f\""
        }
}


