#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------





# Procedure:    text.press
#
# Synopsis:
#       Handle <ButtonPress-1> event in a text widget.
#
# Usage:
#c      text.press pathName x y
#
# Parameters:
#c      pathName
#               Path name of a text widget.
#c      x
#               X co-ordinate of the mouse within the widget.
#c      y
#               Y co-ordinate of the mouse within the widget.
#
# Return value:
#       None
#
# Description:
#       `text.press' handles the <ButtonPress-1> event in a text widget.
#       It replaces Tk's default handler for the widget, and differs from it
#       only in that the `focus' command in the default handler is replaced
#       with `focus_goTo,' to enable focus management.

proc text.press {w x y} {
        global tk_priv
        set tk_priv(selectMode) char
        $w mark set insert @$x,$y
        $w mark set anchor insert
        if {[lindex [$w config -state] 4] == "normal"} {
                focus_goTo $w
        }
}

