#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# Procedure:    labeledentry
#
# Synopsis:
#       Widget that creates an entry box with associated labels.
#
# Usage:
#c      labeledentry pathName ?-option value?...
#
# Parameters:
#c      pathName
#               Path name of the widget
#
# Options:
#       Name:                   head
#       Class:                  Head
#       Command-line switch:    -head
#       Default:                Null string.
#               Text to place before the entry box.
#       Name:                   tail
#       Class:                  Tail
#       Command-lins switch:    -tail
#       Default:                Null string
#               Text to place after the entry box.
#       Name:                   validate
#       Class:                  Validate
#       Command-line switch:    -validate
#       Default:                Null string
#               Procedure to run when focus leaves the entry, to validate
#               its contents.
#
# Return value:
#       Path name of the created widget.
#
# Description:
#       labeledentry creates an entry widget with optional labels to its left
#       and right.  It may also have a validateion procedure supplied, that
#       checks entry contents for validity when focus leaves the entry.
#       (checkInteger and checkReal are two commonly used procedures)
#
# Example:
#
#       The following example creates a box for entering a frequency,
#       specified in MHz, that must be a real number.
#
#c      labeledentry $w.freq -head "Frequency" -tail "MHz" \
#
#c              -validate checkReal
#
# Bugs:
#       The labeled entry is not a first class widget.  It ought to respond
#       to at least the `config' widget command.

        # Default look and feel:

option add *Labeledentry.entry.relief sunken widgetDefault
option add *Labeledentry.entry.borderWidth 2 widgetDefault
option add *Labeledentry.entry.font \
                -*-courier-medium-r-normal--*-120-* \
                widgetDefault
option add *Labeledentry.head.font \
                -*-helvetica-bold-r-normal--*-120-* \
                widgetDefault
option add *Labeledentry.tail.font \
                -*-helvetica-bold-r-normal--*-120-* \
                widgetDefault
option add *Labeledentry.Head {} widgetDefault
option add *Labeledentry.Tail {} widgetDefault
option add *Labeledentry.Validate {} widgetDefault

proc labeledentry {w args} {

        # Make the window

        frame $w -class Labeledentry

        # Defaults

        set head [option get $w head Head]
        set tail [option get $w tail Tail]
        set validate [option get $w validate Validate]
        set entryargs {}

        # Parse command line

        while {[llength $args] > 0} {
                set string [lindex $args 0]
                set args [lrange $args 1 end]
                case $string in {
                        -head {
                                set head [lindex $args 0]
                                set args [lrange $args 1 end]
                        }
                        -tail {
                                set tail [lindex $args 0]
                                set args [lrange $args 1 end]
                        }
                        -validate {
                                set validate [lindex $args 0]
                                set args [lrange $args 1 end]
                        }
                        default {
                                lappend entryargs $string
                                lappend entryargs [lindex $args 0]
                                set args [lrange $args 1 end]
                        }
                }
        }

        # Create subwindows

        if {$head != ""} {
                pack append $w [label $w.head -text $head] {left}
        }
        pack append $w [eval "entry $w.entry $entryargs"] {left expand fillx}
        if {$tail != ""} {
                pack append $w [label $w.tail -text $tail] {left}
        }

        if {$validate != ""} {
                widget_bind $w.entry Validate "$validate $w.entry"
        }

        return $w
}
