#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------





#-------------------------------------------------------------------------
# General routines (shared by goals, terms, types and theorems)
#-------------------------------------------------------------------------

proc HolPP::printer { ppfun kind flagsvar } {
        global TheoremWidgets_flags
        TheoremWidgets::delayedLoadStructuredText
        upvar 1 $flagsvar flags
        if [info exists flags(interface_maps)] {
             set interface_maps $flags(interface_maps)
        } else {
            set interface_maps $TheoremWidgets_flags(interface_maps)
        }
return "HolPPToStrings.val_to_strings
HolBranches.string_of_branch
\{initial_kind=[ml_string $kind],ppfun=$ppfun\}
\{interface_maps=map InterfaceMapsRegistry.find_interface_map \n[ml_stringlist $interface_maps],
parameters=
  \{context=[ml_string ""], 
   first_assum_on_top=[ml_bool $TheoremWidgets_flags(first_assum_on_top)],
   goal_line=[ml_string $TheoremWidgets_flags(goal_line)], 
   number_hyp=[ml_bool $TheoremWidgets_flags(number_hyp)], 
   show_assums=[ml_bool $TheoremWidgets_flags(show_assums)],
   show_restrictions=[ml_bool $TheoremWidgets_flags(show_restrictions)], 
   show_types=[ml_bool $flags(show_types)],
   wrap_terms=[ml_bool $TheoremWidgets_flags(wrap_terms)]\}\}
\{initial_pos=($flags(initial_line),$flags(initial_char)),
   output_width=$flags(width)\}
"

}


proc HolPP::select_subobject { class textw objspec path } {
        # puts "In HolPP::select_subobject, class = $class, textw = $textw, objspec = $objspec, path = $path"
        global vals
        set operations ""
        set hol_termpath  ""
        
        set outermost_term_access ""
        foreach item $path {
            switch -glob -- $item {
                HY?* { 
                    regexp HY(.*) $item dummy hyp
                    switch -- $class THM {
                        set operation "el $hyp o hyp"
                    } GOAL { 
                        set operation "el $hyp o fst"
                    }
                    set outermost_term_access [linsert $outermost_term_access 0 $operation]
                }
                L { set operation rator ; lappend hol_termpath HolTermPaths.RATOR\n }
                R { set operation rand ; lappend hol_termpath HolTermPaths.RAND\n }
                B { set operation body ; lappend hol_termpath HolTermPaths.BODY\n }
                EX { set operation bvar }
                TA?* { 
                    regexp TA(.*) $item dummy tyarg
                    set operation "el $tyarg o #Args o dest_type"
                }
                C { 
                    switch -- $class THM {
                        set operation "concl"
                    } GOAL { 
                        set operation "snd"
                    }
                    set outermost_term_access [linsert $outermost_term_access 0 $operation]
                }
                TY { set operation type_of }
                default { error "unknown location identifier $item in term tag" }
            }
            set operations [linsert $operations 0 $operation]
        }
        if {[llength $path] == 0} {
            switch -glob -- $class THM { 
                set selection_types {HOL_THMCODE STRING} 
            } GOAL { 
                set selection_types ""
            }
        } else {
            switch -glob -- $item {
                HY?* { set selection_types {HOL_TERMCODE HOL_TERM STRING} }
                TA?* { set selection_types {HOL_TYPECODE HOL_TYPE STRING} }
                TY { set selection_types {HOL_TYPECODE HOL_TYPE STRING} }
                EX { set selection_types {HOL_TERMCODE HOL_TERM} }
                default { set selection_types {HOL_TERMCODE HOL_TERM HOL_TERMPATTERN STRING HOL_TERMPATH} }
            }
        }
        catch {
            unset vals(selection,HOL_TERMPATH)
            unset vals(selection,HOL_TERMCODE)
            unset vals(selection,HOL_TYPECODE)
            unset vals(selection,HOL_THMCODE)
        }
        set objcode ([$class::code $objspec])
        if {[llength $operations]==0} {
            set mlcode $objcode
        } else {
            set mlcode "(([join $operations " o \n"]) $objcode)"
        }
        if {[llength $outermost_term_access]==0} {
            set outermost_term_access_code $objcode
        } else {
            set outermost_term_access_code "(([join $outermost_term_access " o \n"]) $objcode)"
        }
        set vals(selection,HOL_TERMPATH) [ml_list $hol_termpath]
        set vals(selection,HOL_OUTERMOST_TERM_CODE) $outermost_term_access_code
        set code_selection_type [lindex $selection_types 0]
        set vals(selection,$code_selection_type) $mlcode
        foreach selection_type $selection_types {
            selection handle $textw "HolPP::provide_selection_$selection_type" $selection_type
        }
        #puts "textw = $textw, get = [selection get]"
        #puts "selection own = [selection own]"
        return $selection_types
}

proc HolPP::provide_selection_STRING { from size } {
        global vals
        global TheoremWidgets_flags
        if [info exists vals(selection,HOL_TERMCODE)] {
            TheoremWidgets::delayedLoadPlainText
            set text [hol_term [ML "Plaintext.term_to_string \{
                                output_width=72,
                                show_types=[ml_bool $TheoremWidgets_flags(pasteWithTypes)]
                        \} $vals(selection,HOL_TERMCODE)"]]
        } elseif [info exists vals(selection,HOL_THMCODE)] {
            set text $vals(selection,HOL_THMCODE)
        } elseif [info exists vals(selection,HOL_TYPECODE)] {
            set text [hol_type [ML "type_to_string $vals(selection,HOL_TYPECODE)"]]
        } else {
            error "no STRING selection"
        }
        puts "selection = [string range $text $from [expr $from+$size-1]]"
        string range $text $from [expr $from+$size-1]
}
proc HolPP::provide_selection_HOL_TERMCODE { from size } {
        global vals
        string range $vals(selection,HOL_TERMCODE) $from [expr $from+$size-1]
}
proc HolPP::provide_selection_HOL_TERMPATH { from size } {
        global vals
        string range $vals(selection,HOL_TERMPATH) $from [expr $from+$size-1]
}
proc HolPP::provide_selection_HOL_TERMPATTERN { from size } {
        global vals
        set text "(-|`[ML "HolTermPatterns.string_of_termpattern 
(HolTermPatterns.general_matching_termpattern 
  ($vals(selection,HOL_TERMPATH),
   $vals(selection,HOL_OUTERMOST_TERM_CODE) ))"]`|-)"
        string range $text $from [expr $from+$size-1]
}
proc HolPP::provide_selection_HOL_TERM { from size } {
        global vals
        upvar #0 $w data
            TheoremWidgets::delayedLoadPlainText
            set text [hol_term [ML "Plaintext.term_to_string \{
                                output_width=72,
                                show_types=true
                        \} $vals(selection,HOL_TERMCODE)"]]
        string range $text $from [expr $from+$size-1]
}

proc HolPP::provide_selection_HOL_TYPECODE { from size } {
        global vals
        string range $vals(selection,HOL_TYPECODE) $from [expr $from+$size-1]
}

proc HolPP::provide_selection_HOL_THMCODE { from size } {
        global vals
        string range $vals(selection,HOL_THMCODE) $from [expr $from+$size-1]
}



#-------------------------------------------------------------------------
# Particular routines for goals, terms, types and theorems
#
# Each set of routines defines a class of object suitable for display
# in a RichText window.
#-------------------------------------------------------------------------


proc THM::header { objspec } {
        switch [lindex $objspec 0] "CODE" {
            return ""
        } default {
            set thmname [lindex $objspec 0]
            set thmtype [lindex $objspec 1]
            set theory [lindex $objspec 2]
            return [list [list "$thmname " thmname] \
                 [list "  ($thmtype in $theory.th)\n" thmorigin]]
        }
}


proc THM::code { objspec } {
        switch [lindex $objspec 0] "CODE" {
            return [lindex $objspec 1]
        } default {
            set thmname [lindex $objspec 0]
            set thmtype [lindex $objspec 1]
            set theory [lindex $objspec 2]
            return "[lindex $objspec 1] [ml_string [lindex $objspec 2]] [ml_string [lindex $objspec 0]]"
        }
}

proc THM::structuredtext_printer { flagsvar } {
        upvar 1 $flagsvar flags
        return [HolPP::printer HolPP.pp_thm THM flags]
}

proc THM::plaintext_printer { flagsvar } {
        global TheoremWidgets_flags
        TheoremWidgets::delayedLoadPlainText
        upvar 1 $flagsvar flags
        if [hol90] {
            return "Plaintext.thm_to_string \{
                        output_width=$flags(width),
                        show_types=[ml_bool $flags(show_types)],
                        show_assums=[ml_bool $TheoremWidgets_flags(show_assums)]
                \}"
        }
}

proc THM::select_subobject { textw objspec path } {
        return [HolPP::select_subobject THM $textw $objspec $path]
}



proc GOAL::header { objspec } {
            return [lindex $objspec 1]
}


proc GOAL::code { objspec } {
            return [lindex $objspec 1]
}

proc GOAL::structuredtext_printer { flagsvar } {
        upvar 1 $flagsvar flags
        return [HolPP::printer HolPP.pp_goal GOAL flags]
}

proc GOAL::plaintext_printer { flagsvar } {
        global TheoremWidgets_flags
        TheoremWidgets::delayedLoadPlainText
        upvar 1 $flagsvar flags
        if [hol90] {
            return "Plaintext.goal_to_string \{
                        output_width=$flags(width),
                        show_types=[ml_bool $flags(show_types)],
                        number_assums=[ml_bool $TheoremWidgets_flags(number_hyp)],
                        first_assum_on_top=[ml_bool $TheoremWidgets_flags(first_assum_on_top)]
                \}"
        }
}

proc GOAL::select_subobject { textw objspec path } {
        return [HolPP::select_subobject GOAL $textw $objspec $path]
}

proc TERM::header { objspec } {
            return [lindex $objspec 1]
}


proc TERM::code { objspec } {
            return [lindex $objspec 1]
}

proc TERM::structuredtext_printer { flagsvar } {
        upvar 1 $flagsvar flags
        return [HolPP::printer HolPP.pp_term TERM flags]
}

proc TERM::plaintext_printer { flagsvar } {
        global TheoremWidgets_flags
        upvar 1 $flagsvar flags
        if [hol90] {
            return "Plaintext.term_to_string \{
                        output_width=$flags(width),
                        show_types=$flags(show_types)
                \}"
        }
}

proc TERM::select_subobject { textw objspec path } {
        return [HolPP::select_subobject TERM $textw $objspec $path]
}


proc TYPE::header { objspec } {
        return [lindex $objspec 1]
}


proc TYPE::code { objspec } {
            return [lindex $objspec 1]
}

proc TYPE::structuredtext_printer { flagsvar } {
        upvar 1 $flagsvar flags
        return [HolPP::printer HolPP.pp_type TYPE flags]
}

proc TYPE::plaintext_printer { flagsvar } {
        global TheoremWidgets_flags
        TheoremWidgets::delayedLoadPlainText
        upvar 1 $flagsvar flags
        if [hol90] {
            return "Plaintext.type_to_string \{
                        output_width=$flags(width)
                \} ($code)"
        }
}

proc TYPE::select_subobject { textw objspec path } {
        return [HolPP::select_subobject TYPE $textw $objspec $path]
}



