#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




proc SourceBrowser::ProcessArgs { argc argv } {
        global SourceBrowser_flags
        global gui_flags

        if {[llength [info commands Preferences_Add]]==1} {

            Preferences_Add "SourceBrowser" " \
Options concerning the Source Browser may be specified here." \
                [list \
                    [list SourceBrowser_flags(collapseLocals) collapseLocals \
                        BOOL 1 "Collapse Local Declarations"  \
                        "Whether to collapse local ... in ... end declarations and just expand everything at the top level" \
                    ] \
                    [list SourceBrowser_flags(makeSource) makeSource \
                        BOOL 0 "Execute \"make\" before reading each source file"  \
"If this is true then $gui_flags(title) will execute \
\"make <filename>\" before analysing in any source file.  This allows \
users who use literate programming tools such as NOWEB \
to have the correct, updated version of their ML source files \
analysed." \
                    ] \
                    [list SourceBrowser_flags(useLinefinder) useLinefinder \
                        BOOL 0 {Look for #line directives} \
"If this is true then when $gui_flags(title) displays a chunk of \
ML source, it will determine the origin of the source by using \
\#line directives in the ML source file.  These should be enclosed \
in ML comments in the following fashion:
        (* #line mk_file.nw 203 *)
which indicates that the next line of the ML file corresponds to \
line 203 of the file mk_file.nw  This allows \
users who use literate programming tools such as NOWEB \
to access their \"real\" source files." \
                    ] \
                ]
        }
}


